package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Integer;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class L4MatchAttributesFluentImpl<A extends L4MatchAttributesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements L4MatchAttributesFluent<A>{

    private List<String> destinationSubnets;
    private List<String> gateways;
    private Integer port;
    private Map<String,String> sourceLabels;
    private String sourceSubnet;

    public L4MatchAttributesFluentImpl(){
    }
    public L4MatchAttributesFluentImpl(L4MatchAttributes instance){
            this.withDestinationSubnets(instance.getDestinationSubnets()); 
            this.withGateways(instance.getGateways()); 
            this.withPort(instance.getPort()); 
            this.withSourceLabels(instance.getSourceLabels()); 
            this.withSourceSubnet(instance.getSourceSubnet()); 
    }

    public A addToDestinationSubnets(int index,String item){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            this.destinationSubnets.add(index, item);
            return (A)this;
    }

    public A setToDestinationSubnets(int index,String item){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            this.destinationSubnets.set(index, item); return (A)this;
    }

    public A addToDestinationSubnets(String... items){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
    }

    public A addAllToDestinationSubnets(Collection<String> items){
            if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
            for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
    }

    public A removeFromDestinationSubnets(String... items){
            for (String item : items) {if (this.destinationSubnets!= null){ this.destinationSubnets.remove(item);}} return (A)this;
    }

    public A removeAllFromDestinationSubnets(Collection<String> items){
            for (String item : items) {if (this.destinationSubnets!= null){ this.destinationSubnets.remove(item);}} return (A)this;
    }

    public List<String> getDestinationSubnets(){
            return this.destinationSubnets;
    }

    public String getDestinationSubnet(int index){
            return this.destinationSubnets.get(index);
    }

    public String getFirstDestinationSubnet(){
            return this.destinationSubnets.get(0);
    }

    public String getLastDestinationSubnet(){
            return this.destinationSubnets.get(destinationSubnets.size() - 1);
    }

    public String getMatchingDestinationSubnet(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: destinationSubnets) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withDestinationSubnets(List<String> destinationSubnets){
            if (this.destinationSubnets != null) { _visitables.removeAll(this.destinationSubnets);}
            if (destinationSubnets != null) {this.destinationSubnets = new ArrayList<String>(); for (String item : destinationSubnets){this.addToDestinationSubnets(item);}} else { this.destinationSubnets = null;} return (A) this;
    }

    public A withDestinationSubnets(String... destinationSubnets){
            if (this.destinationSubnets != null) {this.destinationSubnets.clear();}
            if (destinationSubnets != null) {for (String item :destinationSubnets){ this.addToDestinationSubnets(item);}} return (A) this;
    }

    public Boolean hasDestinationSubnets(){
            return destinationSubnets != null && !destinationSubnets.isEmpty();
    }

    public A addToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.add(index, item);
            return (A)this;
    }

    public A setToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.set(index, item); return (A)this;
    }

    public A addToGateways(String... items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A addAllToGateways(Collection<String> items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A removeFromGateways(String... items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public A removeAllFromGateways(Collection<String> items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public List<String> getGateways(){
            return this.gateways;
    }

    public String getGateway(int index){
            return this.gateways.get(index);
    }

    public String getFirstGateway(){
            return this.gateways.get(0);
    }

    public String getLastGateway(){
            return this.gateways.get(gateways.size() - 1);
    }

    public String getMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withGateways(List<String> gateways){
            if (this.gateways != null) { _visitables.removeAll(this.gateways);}
            if (gateways != null) {this.gateways = new ArrayList<String>(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
    }

    public A withGateways(String... gateways){
            if (this.gateways != null) {this.gateways.clear();}
            if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
    }

    public Boolean hasGateways(){
            return gateways != null && !gateways.isEmpty();
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(String arg1){
            return (A)withPort(new Integer(arg1));
    }

    public A withNewPort(int arg1){
            return (A)withPort(new Integer(arg1));
    }

    public A addToSourceLabels(String key,String value){
            if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
    }

    public A addToSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null && map != null) { this.sourceLabels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
    }

    public A removeFromSourceLabels(String key){
            if(this.sourceLabels == null) { return (A) this; }
            if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
    }

    public A removeFromSourceLabels(Map<String,String> map){
            if(this.sourceLabels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getSourceLabels(){
            return this.sourceLabels;
    }

    public A withSourceLabels(Map<String,String> sourceLabels){
            if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new LinkedHashMap<String,String>(sourceLabels);} return (A) this;
    }

    public Boolean hasSourceLabels(){
            return this.sourceLabels != null;
    }

    public String getSourceSubnet(){
            return this.sourceSubnet;
    }

    public A withSourceSubnet(String sourceSubnet){
            this.sourceSubnet=sourceSubnet; return (A) this;
    }

    public Boolean hasSourceSubnet(){
            return this.sourceSubnet != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            L4MatchAttributesFluentImpl that = (L4MatchAttributesFluentImpl) o;
            if (destinationSubnets != null ? !destinationSubnets.equals(that.destinationSubnets) :that.destinationSubnets != null) return false;
            if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
            if (sourceSubnet != null ? !sourceSubnet.equals(that.sourceSubnet) :that.sourceSubnet != null) return false;
            return true;
    }




}
