package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ListenerMatchFluent<A extends ListenerMatchFluent<A>> extends Fluent<A>{


    public A addToAddress(int index,String item);
    public A setToAddress(int index,String item);
    public A addToAddress(String... items);
    public A addAllToAddress(Collection<String> items);
    public A removeFromAddress(String... items);
    public A removeAllFromAddress(Collection<String> items);
    public List<String> getAddress();
    public String getAddress(int index);
    public String getFirstAddress();
    public String getLastAddress();
    public String getMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAddress(List<String> address);
    public A withAddress(String... address);
    public Boolean hasAddress();
    public ListenerProtocol getListenerProtocol();
    public A withListenerProtocol(ListenerProtocol listenerProtocol);
    public Boolean hasListenerProtocol();
    public ListenerType getListenerType();
    public A withListenerType(ListenerType listenerType);
    public Boolean hasListenerType();
    public String getPortNamePrefix();
    public A withPortNamePrefix(String portNamePrefix);
    public Boolean hasPortNamePrefix();
    public Integer getPortNumber();
    public A withPortNumber(Integer portNumber);
    public Boolean hasPortNumber();
    public A withNewPortNumber(String arg1);
    public A withNewPortNumber(int arg1);



}
