package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class OutlierDetectionBuilder extends OutlierDetectionFluentImpl<OutlierDetectionBuilder> implements VisitableBuilder<OutlierDetection,OutlierDetectionBuilder>{

    OutlierDetectionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OutlierDetectionBuilder(){
            this(true);
    }
    public OutlierDetectionBuilder(Boolean validationEnabled){
            this(new OutlierDetection(), validationEnabled);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent){
            this(fluent, true);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OutlierDetection(), validationEnabled);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance){
            this(fluent, instance, true);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBaseEjectionTime(instance.getBaseEjectionTime()); 
            fluent.withConsecutiveErrors(instance.getConsecutiveErrors()); 
            fluent.withInterval(instance.getInterval()); 
            fluent.withMaxEjectionPercent(instance.getMaxEjectionPercent()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutlierDetectionBuilder(OutlierDetection instance){
            this(instance,true);
    }
    public OutlierDetectionBuilder(OutlierDetection instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBaseEjectionTime(instance.getBaseEjectionTime()); 
            this.withConsecutiveErrors(instance.getConsecutiveErrors()); 
            this.withInterval(instance.getInterval()); 
            this.withMaxEjectionPercent(instance.getMaxEjectionPercent()); 
            this.validationEnabled = validationEnabled; 
    }
    public OutlierDetectionBuilder(Validator validator){
            this(new OutlierDetection(), true);
    }
    public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance,Validator validator){
            this.fluent = fluent; 
            fluent.withBaseEjectionTime(instance.getBaseEjectionTime()); 
            fluent.withConsecutiveErrors(instance.getConsecutiveErrors()); 
            fluent.withInterval(instance.getInterval()); 
            fluent.withMaxEjectionPercent(instance.getMaxEjectionPercent()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public OutlierDetectionBuilder(OutlierDetection instance,Validator validator){
            this.fluent = this; 
            this.withBaseEjectionTime(instance.getBaseEjectionTime()); 
            this.withConsecutiveErrors(instance.getConsecutiveErrors()); 
            this.withInterval(instance.getInterval()); 
            this.withMaxEjectionPercent(instance.getMaxEjectionPercent()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public OutlierDetection build(){
            OutlierDetection buildable = new OutlierDetection(fluent.getBaseEjectionTime(),fluent.getConsecutiveErrors(),fluent.getInterval(),fluent.getMaxEjectionPercent());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OutlierDetectionBuilder that = (OutlierDetectionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
