package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServerBuilder extends ServerFluentImpl<ServerBuilder> implements VisitableBuilder<Server,ServerBuilder>{

    ServerFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServerBuilder(){
            this(true);
    }
    public ServerBuilder(Boolean validationEnabled){
            this(new Server(), validationEnabled);
    }
    public ServerBuilder(ServerFluent<?> fluent){
            this(fluent, true);
    }
    public ServerBuilder(ServerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Server(), validationEnabled);
    }
    public ServerBuilder(ServerFluent<?> fluent,Server instance){
            this(fluent, instance, true);
    }
    public ServerBuilder(ServerFluent<?> fluent,Server instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHosts(instance.getHosts()); 
            fluent.withPort(instance.getPort()); 
            fluent.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServerBuilder(Server instance){
            this(instance,true);
    }
    public ServerBuilder(Server instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHosts(instance.getHosts()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServerBuilder(Validator validator){
            this(new Server(), true);
    }
    public ServerBuilder(ServerFluent<?> fluent,Server instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHosts(instance.getHosts()); 
            fluent.withPort(instance.getPort()); 
            fluent.withTls(instance.getTls()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServerBuilder(Server instance,Validator validator){
            this.fluent = this; 
            this.withHosts(instance.getHosts()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Server build(){
            Server buildable = new Server(fluent.getHosts(),fluent.getPort(),fluent.getTls());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServerBuilder that = (ServerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
