package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface ServiceEntryFluent<A extends ServiceEntryFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ServiceEntryFluent.MetadataNested<A> withNewMetadata();
    public ServiceEntryFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceEntryFluent.MetadataNested<A> editMetadata();
    public ServiceEntryFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceEntryFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceEntrySpec getSpec();
    public ServiceEntrySpec buildSpec();
    public A withSpec(ServiceEntrySpec spec);
    public Boolean hasSpec();
    public ServiceEntryFluent.SpecNested<A> withNewSpec();
    public ServiceEntryFluent.SpecNested<A> withNewSpecLike(ServiceEntrySpec item);
    public ServiceEntryFluent.SpecNested<A> editSpec();
    public ServiceEntryFluent.SpecNested<A> editOrNewSpec();
    public ServiceEntryFluent.SpecNested<A> editOrNewSpecLike(ServiceEntrySpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceEntryFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,ServiceEntrySpecFluent<ServiceEntryFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
