package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServiceEntrySpecBuilder extends ServiceEntrySpecFluentImpl<ServiceEntrySpecBuilder> implements VisitableBuilder<ServiceEntrySpec,ServiceEntrySpecBuilder>{

    ServiceEntrySpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceEntrySpecBuilder(){
            this(true);
    }
    public ServiceEntrySpecBuilder(Boolean validationEnabled){
            this(new ServiceEntrySpec(), validationEnabled);
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceEntrySpec(), validationEnabled);
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,ServiceEntrySpec instance){
            this(fluent, instance, true);
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,ServiceEntrySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddresses(instance.getAddresses()); 
            fluent.withEndpoints(instance.getEndpoints()); 
            fluent.withHosts(instance.getHosts()); 
            fluent.withLocation(instance.getLocation()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withResolution(instance.getResolution()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpec instance){
            this(instance,true);
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddresses(instance.getAddresses()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withHosts(instance.getHosts()); 
            this.withLocation(instance.getLocation()); 
            this.withPorts(instance.getPorts()); 
            this.withResolution(instance.getResolution()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceEntrySpecBuilder(Validator validator){
            this(new ServiceEntrySpec(), true);
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpecFluent<?> fluent,ServiceEntrySpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAddresses(instance.getAddresses()); 
            fluent.withEndpoints(instance.getEndpoints()); 
            fluent.withHosts(instance.getHosts()); 
            fluent.withLocation(instance.getLocation()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withResolution(instance.getResolution()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServiceEntrySpecBuilder(ServiceEntrySpec instance,Validator validator){
            this.fluent = this; 
            this.withAddresses(instance.getAddresses()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withHosts(instance.getHosts()); 
            this.withLocation(instance.getLocation()); 
            this.withPorts(instance.getPorts()); 
            this.withResolution(instance.getResolution()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ServiceEntrySpec build(){
            ServiceEntrySpec buildable = new ServiceEntrySpec(fluent.getAddresses(),fluent.getEndpoints(),fluent.getHosts(),fluent.getLocation(),fluent.getPorts(),fluent.getResolution());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceEntrySpecBuilder that = (ServiceEntrySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
