package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ServiceEntrySpecFluent<A extends ServiceEntrySpecFluent<A>> extends Fluent<A>{


    public A addToAddresses(int index,String item);
    public A setToAddresses(int index,String item);
    public A addToAddresses(String... items);
    public A addAllToAddresses(Collection<String> items);
    public A removeFromAddresses(String... items);
    public A removeAllFromAddresses(Collection<String> items);
    public List<String> getAddresses();
    public String getAddress(int index);
    public String getFirstAddress();
    public String getLastAddress();
    public String getMatchingAddress(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAddresses(List<String> addresses);
    public A withAddresses(String... addresses);
    public Boolean hasAddresses();
    public A addToEndpoints(int index,Endpoint item);
    public A setToEndpoints(int index,Endpoint item);
    public A addToEndpoints(Endpoint... items);
    public A addAllToEndpoints(Collection<Endpoint> items);
    public A removeFromEndpoints(Endpoint... items);
    public A removeAllFromEndpoints(Collection<Endpoint> items);
    
/**
 * This method has been deprecated, please use method buildEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<Endpoint> getEndpoints();
    public List<Endpoint> buildEndpoints();
    public Endpoint buildEndpoint(int index);
    public Endpoint buildFirstEndpoint();
    public Endpoint buildLastEndpoint();
    public Endpoint buildMatchingEndpoint(io.fabric8.kubernetes.api.builder.Predicate<EndpointBuilder> predicate);
    public A withEndpoints(List<Endpoint> endpoints);
    public A withEndpoints(Endpoint... endpoints);
    public Boolean hasEndpoints();
    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpoint();
    public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item);
    public ServiceEntrySpecFluent.EndpointsNested<A> setNewEndpointLike(int index,Endpoint item);
    public ServiceEntrySpecFluent.EndpointsNested<A> editEndpoint(int index);
    public ServiceEntrySpecFluent.EndpointsNested<A> editFirstEndpoint();
    public ServiceEntrySpecFluent.EndpointsNested<A> editLastEndpoint();
    public ServiceEntrySpecFluent.EndpointsNested<A> editMatchingEndpoint(io.fabric8.kubernetes.api.builder.Predicate<EndpointBuilder> predicate);
    public A addToHosts(int index,String item);
    public A setToHosts(int index,String item);
    public A addToHosts(String... items);
    public A addAllToHosts(Collection<String> items);
    public A removeFromHosts(String... items);
    public A removeAllFromHosts(Collection<String> items);
    public List<String> getHosts();
    public String getHost(int index);
    public String getFirstHost();
    public String getLastHost();
    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withHosts(List<String> hosts);
    public A withHosts(String... hosts);
    public Boolean hasHosts();
    public ServiceEntryLocation getLocation();
    public A withLocation(ServiceEntryLocation location);
    public Boolean hasLocation();
    public A addToPorts(int index,me.snowdrop.istio.api.networking.v1alpha3.Port item);
    public A setToPorts(int index,me.snowdrop.istio.api.networking.v1alpha3.Port item);
    public A addToPorts(me.snowdrop.istio.api.networking.v1alpha3.Port... items);
    public A addAllToPorts(Collection<me.snowdrop.istio.api.networking.v1alpha3.Port> items);
    public A removeFromPorts(me.snowdrop.istio.api.networking.v1alpha3.Port... items);
    public A removeAllFromPorts(Collection<me.snowdrop.istio.api.networking.v1alpha3.Port> items);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1alpha3.Port> getPorts();
    public List<me.snowdrop.istio.api.networking.v1alpha3.Port> buildPorts();
    public me.snowdrop.istio.api.networking.v1alpha3.Port buildPort(int index);
    public me.snowdrop.istio.api.networking.v1alpha3.Port buildFirstPort();
    public me.snowdrop.istio.api.networking.v1alpha3.Port buildLastPort();
    public me.snowdrop.istio.api.networking.v1alpha3.Port buildMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate);
    public A withPorts(List<me.snowdrop.istio.api.networking.v1alpha3.Port> ports);
    public A withPorts(me.snowdrop.istio.api.networking.v1alpha3.Port... ports);
    public Boolean hasPorts();
    public A addNewPort(String name,Integer number,String protocol);
    public ServiceEntrySpecFluent.PortsNested<A> addNewPort();
    public ServiceEntrySpecFluent.PortsNested<A> addNewPortLike(me.snowdrop.istio.api.networking.v1alpha3.Port item);
    public ServiceEntrySpecFluent.PortsNested<A> setNewPortLike(int index,me.snowdrop.istio.api.networking.v1alpha3.Port item);
    public ServiceEntrySpecFluent.PortsNested<A> editPort(int index);
    public ServiceEntrySpecFluent.PortsNested<A> editFirstPort();
    public ServiceEntrySpecFluent.PortsNested<A> editLastPort();
    public ServiceEntrySpecFluent.PortsNested<A> editMatchingPort(io.fabric8.kubernetes.api.builder.Predicate<PortBuilder> predicate);
    public ServiceEntryResolution getResolution();
    public A withResolution(ServiceEntryResolution resolution);
    public Boolean hasResolution();

    public interface EndpointsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointFluent<ServiceEntrySpecFluent.EndpointsNested<N>>{

        
    public N and();    public N endEndpoint();
}
    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PortFluent<ServiceEntrySpecFluent.PortsNested<N>>{

        
    public N and();    public N endPort();
}


}
