
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1alpha3.LoadBalancerSettings.LbPolicy;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "simple"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class SimpleLbPolicy implements Serializable, LbPolicy
{

    @JsonProperty("simple")
    private SimpleLB simple;
    private final static long serialVersionUID = 1480177897416814168L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SimpleLbPolicy() {
    }

    /**
     * 
     * @param simple
     */
    public SimpleLbPolicy(SimpleLB simple) {
        super();
        this.simple = simple;
    }

    @JsonProperty("simple")
    public SimpleLB getSimple() {
        return simple;
    }

    @JsonProperty("simple")
    public void setSimple(SimpleLB simple) {
        this.simple = simple;
    }

}
