package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class TCPRouteFluentImpl<A extends TCPRouteFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TCPRouteFluent<A>{

    private List<L4MatchAttributesBuilder> match;
    private List<DestinationWeightBuilder> route;

    public TCPRouteFluentImpl(){
    }
    public TCPRouteFluentImpl(TCPRoute instance){
            this.withMatch(instance.getMatch()); 
            this.withRoute(instance.getRoute()); 
    }

    public A addToMatch(int index,L4MatchAttributes item){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.match.add(index >= 0 ? index : match.size(), builder); return (A)this;
    }

    public A setToMatch(int index,L4MatchAttributes item){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= match.size()) { match.add(builder); } else { match.set(index, builder);}
             return (A)this;
    }

    public A addToMatch(L4MatchAttributes... items){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.add(builder);this.match.add(builder);} return (A)this;
    }

    public A addAllToMatch(Collection<L4MatchAttributes> items){
            if (this.match == null) {this.match = new ArrayList<L4MatchAttributesBuilder>();}
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.add(builder);this.match.add(builder);} return (A)this;
    }

    public A removeFromMatch(L4MatchAttributes... items){
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    public A removeAllFromMatch(Collection<L4MatchAttributes> items){
            for (L4MatchAttributes item : items) {L4MatchAttributesBuilder builder = new L4MatchAttributesBuilder(item);_visitables.remove(builder);if (this.match != null) {this.match.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatch instead.
 * @return The buildable object.
 */
@Deprecated public List<L4MatchAttributes> getMatch(){
            return build(match);
    }

    public List<L4MatchAttributes> buildMatch(){
            return build(match);
    }

    public L4MatchAttributes buildMatch(int index){
            return this.match.get(index).build();
    }

    public L4MatchAttributes buildFirstMatch(){
            return this.match.get(0).build();
    }

    public L4MatchAttributes buildLastMatch(){
            return this.match.get(match.size() - 1).build();
    }

    public L4MatchAttributes buildMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<L4MatchAttributesBuilder> predicate){
            for (L4MatchAttributesBuilder item: match) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withMatch(List<L4MatchAttributes> match){
            if (this.match != null) { _visitables.removeAll(this.match);}
            if (match != null) {this.match = new ArrayList<L4MatchAttributesBuilder>(); for (L4MatchAttributes item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
    }

    public A withMatch(L4MatchAttributes... match){
            if (this.match != null) {this.match.clear();}
            if (match != null) {for (L4MatchAttributes item :match){ this.addToMatch(item);}} return (A) this;
    }

    public Boolean hasMatch(){
            return match != null && !match.isEmpty();
    }

    public TCPRouteFluent.MatchNested<A> addNewMatch(){
            return new MatchNestedImpl();
    }

    public TCPRouteFluent.MatchNested<A> addNewMatchLike(L4MatchAttributes item){
            return new MatchNestedImpl(-1, item);
    }

    public TCPRouteFluent.MatchNested<A> setNewMatchLike(int index,L4MatchAttributes item){
            return new MatchNestedImpl(index, item);
    }

    public TCPRouteFluent.MatchNested<A> editMatch(int index){
            if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public TCPRouteFluent.MatchNested<A> editFirstMatch(){
            if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
            return setNewMatchLike(0, buildMatch(0));
    }

    public TCPRouteFluent.MatchNested<A> editLastMatch(){
            int index = match.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public TCPRouteFluent.MatchNested<A> editMatchingMatch(io.fabric8.kubernetes.api.builder.Predicate<L4MatchAttributesBuilder> predicate){
            int index = -1;
            for (int i=0;i<match.size();i++) { 
            if (predicate.apply(match.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
            return setNewMatchLike(index, buildMatch(index));
    }

    public A addToRoute(int index,DestinationWeight item){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.route.add(index >= 0 ? index : route.size(), builder); return (A)this;
    }

    public A setToRoute(int index,DestinationWeight item){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            DestinationWeightBuilder builder = new DestinationWeightBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= route.size()) { route.add(builder); } else { route.set(index, builder);}
             return (A)this;
    }

    public A addToRoute(DestinationWeight... items){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.add(builder);this.route.add(builder);} return (A)this;
    }

    public A addAllToRoute(Collection<DestinationWeight> items){
            if (this.route == null) {this.route = new ArrayList<DestinationWeightBuilder>();}
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.add(builder);this.route.add(builder);} return (A)this;
    }

    public A removeFromRoute(DestinationWeight... items){
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoute(Collection<DestinationWeight> items){
            for (DestinationWeight item : items) {DestinationWeightBuilder builder = new DestinationWeightBuilder(item);_visitables.remove(builder);if (this.route != null) {this.route.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoute instead.
 * @return The buildable object.
 */
@Deprecated public List<DestinationWeight> getRoute(){
            return build(route);
    }

    public List<DestinationWeight> buildRoute(){
            return build(route);
    }

    public DestinationWeight buildRoute(int index){
            return this.route.get(index).build();
    }

    public DestinationWeight buildFirstRoute(){
            return this.route.get(0).build();
    }

    public DestinationWeight buildLastRoute(){
            return this.route.get(route.size() - 1).build();
    }

    public DestinationWeight buildMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<DestinationWeightBuilder> predicate){
            for (DestinationWeightBuilder item: route) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withRoute(List<DestinationWeight> route){
            if (this.route != null) { _visitables.removeAll(this.route);}
            if (route != null) {this.route = new ArrayList<DestinationWeightBuilder>(); for (DestinationWeight item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
    }

    public A withRoute(DestinationWeight... route){
            if (this.route != null) {this.route.clear();}
            if (route != null) {for (DestinationWeight item :route){ this.addToRoute(item);}} return (A) this;
    }

    public Boolean hasRoute(){
            return route != null && !route.isEmpty();
    }

    public TCPRouteFluent.RouteNested<A> addNewRoute(){
            return new RouteNestedImpl();
    }

    public TCPRouteFluent.RouteNested<A> addNewRouteLike(DestinationWeight item){
            return new RouteNestedImpl(-1, item);
    }

    public TCPRouteFluent.RouteNested<A> setNewRouteLike(int index,DestinationWeight item){
            return new RouteNestedImpl(index, item);
    }

    public TCPRouteFluent.RouteNested<A> editRoute(int index){
            if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public TCPRouteFluent.RouteNested<A> editFirstRoute(){
            if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
            return setNewRouteLike(0, buildRoute(0));
    }

    public TCPRouteFluent.RouteNested<A> editLastRoute(){
            int index = route.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public TCPRouteFluent.RouteNested<A> editMatchingRoute(io.fabric8.kubernetes.api.builder.Predicate<DestinationWeightBuilder> predicate){
            int index = -1;
            for (int i=0;i<route.size();i++) { 
            if (predicate.apply(route.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
            return setNewRouteLike(index, buildRoute(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TCPRouteFluentImpl that = (TCPRouteFluentImpl) o;
            if (match != null ? !match.equals(that.match) :that.match != null) return false;
            if (route != null ? !route.equals(that.route) :that.route != null) return false;
            return true;
    }


    public class MatchNestedImpl<N> extends L4MatchAttributesFluentImpl<TCPRouteFluent.MatchNested<N>> implements TCPRouteFluent.MatchNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final L4MatchAttributesBuilder builder;
        private final int index;
    
            MatchNestedImpl(int index,L4MatchAttributes item){
                    this.index = index;
                    this.builder = new L4MatchAttributesBuilder(this, item);
            }
            MatchNestedImpl(){
                    this.index = -1;
                    this.builder = new L4MatchAttributesBuilder(this);
            }
    
    public N and(){
            return (N) TCPRouteFluentImpl.this.setToMatch(index, builder.build());
    }
    public N endMatch(){
            return and();
    }

}
    public class RouteNestedImpl<N> extends DestinationWeightFluentImpl<TCPRouteFluent.RouteNested<N>> implements TCPRouteFluent.RouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DestinationWeightBuilder builder;
        private final int index;
    
            RouteNestedImpl(int index,DestinationWeight item){
                    this.index = index;
                    this.builder = new DestinationWeightBuilder(this, item);
            }
            RouteNestedImpl(){
                    this.index = -1;
                    this.builder = new DestinationWeightBuilder(this);
            }
    
    public N and(){
            return (N) TCPRouteFluentImpl.this.setToRoute(index, builder.build());
    }
    public N endRoute(){
            return and();
    }

}


}
