
package me.snowdrop.istio.api.networking.v1alpha3;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectTimeout",
    "maxConnections"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TCPSettings implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    @JsonPropertyDescription("")
    @Valid
    private Duration connectTimeout;
    /**
     * 
     * 
     */
    @JsonProperty("maxConnections")
    @JsonPropertyDescription("")
    private Integer maxConnections;
    private final static long serialVersionUID = -4032639817573746590L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TCPSettings() {
    }

    /**
     * 
     * @param connectTimeout
     * @param maxConnections
     */
    public TCPSettings(Duration connectTimeout, Integer maxConnections) {
        super();
        this.connectTimeout = connectTimeout;
        this.maxConnections = maxConnections;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("connectTimeout")
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxConnections")
    public Integer getMaxConnections() {
        return maxConnections;
    }

    /**
     * 
     * 
     */
    @JsonProperty("maxConnections")
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

}
