package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Predicate;

public interface TLSOptionsFluent<A extends TLSOptionsFluent<A>> extends Fluent<A>{


    public String getCaCertificates();
    public A withCaCertificates(String caCertificates);
    public Boolean hasCaCertificates();
    public Boolean isHttpsRedirect();
    public A withHttpsRedirect(Boolean httpsRedirect);
    public Boolean hasHttpsRedirect();
    public A withNewHttpsRedirect(String arg1);
    public A withNewHttpsRedirect(boolean arg1);
    public TLSOptionsMode getMode();
    public A withMode(TLSOptionsMode mode);
    public Boolean hasMode();
    public String getPrivateKey();
    public A withPrivateKey(String privateKey);
    public Boolean hasPrivateKey();
    public String getServerCertificate();
    public A withServerCertificate(String serverCertificate);
    public Boolean hasServerCertificate();
    public A addToSubjectAltNames(int index,String item);
    public A setToSubjectAltNames(int index,String item);
    public A addToSubjectAltNames(String... items);
    public A addAllToSubjectAltNames(Collection<String> items);
    public A removeFromSubjectAltNames(String... items);
    public A removeAllFromSubjectAltNames(Collection<String> items);
    public List<String> getSubjectAltNames();
    public String getSubjectAltName(int index);
    public String getFirstSubjectAltName();
    public String getLastSubjectAltName();
    public String getMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withSubjectAltNames(List<String> subjectAltNames);
    public A withSubjectAltNames(String... subjectAltNames);
    public Boolean hasSubjectAltNames();



}
