package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TLSOptionsFluentImpl<A extends TLSOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TLSOptionsFluent<A>{

    private String caCertificates;
    private Boolean httpsRedirect;
    private TLSOptionsMode mode;
    private String privateKey;
    private String serverCertificate;
    private List<String> subjectAltNames;

    public TLSOptionsFluentImpl(){
    }
    public TLSOptionsFluentImpl(TLSOptions instance){
            this.withCaCertificates(instance.getCaCertificates()); 
            this.withHttpsRedirect(instance.getHttpsRedirect()); 
            this.withMode(instance.getMode()); 
            this.withPrivateKey(instance.getPrivateKey()); 
            this.withServerCertificate(instance.getServerCertificate()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
    }

    public String getCaCertificates(){
            return this.caCertificates;
    }

    public A withCaCertificates(String caCertificates){
            this.caCertificates=caCertificates; return (A) this;
    }

    public Boolean hasCaCertificates(){
            return this.caCertificates != null;
    }

    public Boolean isHttpsRedirect(){
            return this.httpsRedirect;
    }

    public A withHttpsRedirect(Boolean httpsRedirect){
            this.httpsRedirect=httpsRedirect; return (A) this;
    }

    public Boolean hasHttpsRedirect(){
            return this.httpsRedirect != null;
    }

    public A withNewHttpsRedirect(String arg1){
            return (A)withHttpsRedirect(new Boolean(arg1));
    }

    public A withNewHttpsRedirect(boolean arg1){
            return (A)withHttpsRedirect(new Boolean(arg1));
    }

    public TLSOptionsMode getMode(){
            return this.mode;
    }

    public A withMode(TLSOptionsMode mode){
            this.mode=mode; return (A) this;
    }

    public Boolean hasMode(){
            return this.mode != null;
    }

    public String getPrivateKey(){
            return this.privateKey;
    }

    public A withPrivateKey(String privateKey){
            this.privateKey=privateKey; return (A) this;
    }

    public Boolean hasPrivateKey(){
            return this.privateKey != null;
    }

    public String getServerCertificate(){
            return this.serverCertificate;
    }

    public A withServerCertificate(String serverCertificate){
            this.serverCertificate=serverCertificate; return (A) this;
    }

    public Boolean hasServerCertificate(){
            return this.serverCertificate != null;
    }

    public A addToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.add(index, item);
            return (A)this;
    }

    public A setToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.set(index, item); return (A)this;
    }

    public A addToSubjectAltNames(String... items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A addAllToSubjectAltNames(Collection<String> items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A removeFromSubjectAltNames(String... items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public A removeAllFromSubjectAltNames(Collection<String> items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public List<String> getSubjectAltNames(){
            return this.subjectAltNames;
    }

    public String getSubjectAltName(int index){
            return this.subjectAltNames.get(index);
    }

    public String getFirstSubjectAltName(){
            return this.subjectAltNames.get(0);
    }

    public String getLastSubjectAltName(){
            return this.subjectAltNames.get(subjectAltNames.size() - 1);
    }

    public String getMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: subjectAltNames) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withSubjectAltNames(List<String> subjectAltNames){
            if (this.subjectAltNames != null) { _visitables.removeAll(this.subjectAltNames);}
            if (subjectAltNames != null) {this.subjectAltNames = new ArrayList<String>(); for (String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
    }

    public A withSubjectAltNames(String... subjectAltNames){
            if (this.subjectAltNames != null) {this.subjectAltNames.clear();}
            if (subjectAltNames != null) {for (String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
    }

    public Boolean hasSubjectAltNames(){
            return subjectAltNames != null && !subjectAltNames.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TLSOptionsFluentImpl that = (TLSOptionsFluentImpl) o;
            if (caCertificates != null ? !caCertificates.equals(that.caCertificates) :that.caCertificates != null) return false;
            if (httpsRedirect != null ? !httpsRedirect.equals(that.httpsRedirect) :that.httpsRedirect != null) return false;
            if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
            if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
            if (serverCertificate != null ? !serverCertificate.equals(that.serverCertificate) :that.serverCertificate != null) return false;
            if (subjectAltNames != null ? !subjectAltNames.equals(that.subjectAltNames) :that.subjectAltNames != null) return false;
            return true;
    }




}
