package me.snowdrop.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class TrafficPolicyFluentImpl<A extends TrafficPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TrafficPolicyFluent<A>{

    private ConnectionPoolSettingsBuilder connectionPool;
    private LoadBalancerSettingsBuilder loadBalancer;
    private OutlierDetectionBuilder outlierDetection;
    private List<PortTrafficPolicyBuilder> portLevelSettings;
    private TLSSettingsBuilder tls;

    public TrafficPolicyFluentImpl(){
    }
    public TrafficPolicyFluentImpl(TrafficPolicy instance){
            this.withConnectionPool(instance.getConnectionPool()); 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.withOutlierDetection(instance.getOutlierDetection()); 
            this.withPortLevelSettings(instance.getPortLevelSettings()); 
            this.withTls(instance.getTls()); 
    }

    
/**
 * This method has been deprecated, please use method buildConnectionPool instead.
 * @return The buildable object.
 */
@Deprecated public ConnectionPoolSettings getConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public ConnectionPoolSettings buildConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public A withConnectionPool(ConnectionPoolSettings connectionPool){
            _visitables.remove(this.connectionPool);
            if (connectionPool!=null){ this.connectionPool= new ConnectionPoolSettingsBuilder(connectionPool); _visitables.add(this.connectionPool);} return (A) this;
    }

    public Boolean hasConnectionPool(){
            return this.connectionPool != null;
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPool(){
            return new ConnectionPoolNestedImpl();
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item){
            return new ConnectionPoolNestedImpl(item);
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> editConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool());
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): new ConnectionPoolSettingsBuilder().build());
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public LoadBalancerSettings getLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public LoadBalancerSettings buildLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(LoadBalancerSettings loadBalancer){
            _visitables.remove(this.loadBalancer);
            if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerSettingsBuilder(loadBalancer); _visitables.add(this.loadBalancer);} return (A) this;
    }

    public Boolean hasLoadBalancer(){
            return this.loadBalancer != null;
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancer(){
            return new LoadBalancerNestedImpl();
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item){
            return new LoadBalancerNestedImpl(item);
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> editLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer());
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new LoadBalancerSettingsBuilder().build());
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOutlierDetection instead.
 * @return The buildable object.
 */
@Deprecated public OutlierDetection getOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public OutlierDetection buildOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public A withOutlierDetection(OutlierDetection outlierDetection){
            _visitables.remove(this.outlierDetection);
            if (outlierDetection!=null){ this.outlierDetection= new OutlierDetectionBuilder(outlierDetection); _visitables.add(this.outlierDetection);} return (A) this;
    }

    public Boolean hasOutlierDetection(){
            return this.outlierDetection != null;
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetection(){
            return new OutlierDetectionNestedImpl();
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item){
            return new OutlierDetectionNestedImpl(item);
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> editOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection());
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): new OutlierDetectionBuilder().build());
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): item);
    }

    public A addToPortLevelSettings(int index,PortTrafficPolicy item){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();}
            PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.portLevelSettings.add(index >= 0 ? index : portLevelSettings.size(), builder); return (A)this;
    }

    public A setToPortLevelSettings(int index,PortTrafficPolicy item){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();}
            PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= portLevelSettings.size()) { portLevelSettings.add(builder); } else { portLevelSettings.set(index, builder);}
             return (A)this;
    }

    public A addToPortLevelSettings(PortTrafficPolicy... items){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();}
            for (PortTrafficPolicy item : items) {PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);_visitables.add(builder);this.portLevelSettings.add(builder);} return (A)this;
    }

    public A addAllToPortLevelSettings(Collection<PortTrafficPolicy> items){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();}
            for (PortTrafficPolicy item : items) {PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);_visitables.add(builder);this.portLevelSettings.add(builder);} return (A)this;
    }

    public A removeFromPortLevelSettings(PortTrafficPolicy... items){
            for (PortTrafficPolicy item : items) {PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);_visitables.remove(builder);if (this.portLevelSettings != null) {this.portLevelSettings.remove(builder);}} return (A)this;
    }

    public A removeAllFromPortLevelSettings(Collection<PortTrafficPolicy> items){
            for (PortTrafficPolicy item : items) {PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);_visitables.remove(builder);if (this.portLevelSettings != null) {this.portLevelSettings.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPortLevelSettings instead.
 * @return The buildable object.
 */
@Deprecated public List<PortTrafficPolicy> getPortLevelSettings(){
            return build(portLevelSettings);
    }

    public List<PortTrafficPolicy> buildPortLevelSettings(){
            return build(portLevelSettings);
    }

    public PortTrafficPolicy buildPortLevelSetting(int index){
            return this.portLevelSettings.get(index).build();
    }

    public PortTrafficPolicy buildFirstPortLevelSetting(){
            return this.portLevelSettings.get(0).build();
    }

    public PortTrafficPolicy buildLastPortLevelSetting(){
            return this.portLevelSettings.get(portLevelSettings.size() - 1).build();
    }

    public PortTrafficPolicy buildMatchingPortLevelSetting(io.fabric8.kubernetes.api.builder.Predicate<PortTrafficPolicyBuilder> predicate){
            for (PortTrafficPolicyBuilder item: portLevelSettings) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withPortLevelSettings(List<PortTrafficPolicy> portLevelSettings){
            if (this.portLevelSettings != null) { _visitables.removeAll(this.portLevelSettings);}
            if (portLevelSettings != null) {this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>(); for (PortTrafficPolicy item : portLevelSettings){this.addToPortLevelSettings(item);}} else { this.portLevelSettings = null;} return (A) this;
    }

    public A withPortLevelSettings(PortTrafficPolicy... portLevelSettings){
            if (this.portLevelSettings != null) {this.portLevelSettings.clear();}
            if (portLevelSettings != null) {for (PortTrafficPolicy item :portLevelSettings){ this.addToPortLevelSettings(item);}} return (A) this;
    }

    public Boolean hasPortLevelSettings(){
            return portLevelSettings != null && !portLevelSettings.isEmpty();
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSetting(){
            return new PortLevelSettingsNestedImpl();
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSettingLike(PortTrafficPolicy item){
            return new PortLevelSettingsNestedImpl(-1, item);
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> setNewPortLevelSettingLike(int index,PortTrafficPolicy item){
            return new PortLevelSettingsNestedImpl(index, item);
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editPortLevelSetting(int index){
            if (portLevelSettings.size() <= index) throw new RuntimeException("Can't edit portLevelSettings. Index exceeds size.");
            return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editFirstPortLevelSetting(){
            if (portLevelSettings.size() == 0) throw new RuntimeException("Can't edit first portLevelSettings. The list is empty.");
            return setNewPortLevelSettingLike(0, buildPortLevelSetting(0));
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editLastPortLevelSetting(){
            int index = portLevelSettings.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last portLevelSettings. The list is empty.");
            return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editMatchingPortLevelSetting(io.fabric8.kubernetes.api.builder.Predicate<PortTrafficPolicyBuilder> predicate){
            int index = -1;
            for (int i=0;i<portLevelSettings.size();i++) { 
            if (predicate.apply(portLevelSettings.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching portLevelSettings. No match found.");
            return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public TLSSettings getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public TLSSettings buildTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(TLSSettings tls){
            _visitables.remove(this.tls);
            if (tls!=null){ this.tls= new TLSSettingsBuilder(tls); _visitables.add(this.tls);} return (A) this;
    }

    public Boolean hasTls(){
            return this.tls != null;
    }

    public TrafficPolicyFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public TrafficPolicyFluent.TlsNested<A> withNewTlsLike(TLSSettings item){
            return new TlsNestedImpl(item);
    }

    public TrafficPolicyFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public TrafficPolicyFluent.TlsNested<A> editOrNewTls(){
            return withNewTlsLike(getTls() != null ? getTls(): new TLSSettingsBuilder().build());
    }

    public TrafficPolicyFluent.TlsNested<A> editOrNewTlsLike(TLSSettings item){
            return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TrafficPolicyFluentImpl that = (TrafficPolicyFluentImpl) o;
            if (connectionPool != null ? !connectionPool.equals(that.connectionPool) :that.connectionPool != null) return false;
            if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
            if (outlierDetection != null ? !outlierDetection.equals(that.outlierDetection) :that.outlierDetection != null) return false;
            if (portLevelSettings != null ? !portLevelSettings.equals(that.portLevelSettings) :that.portLevelSettings != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class ConnectionPoolNestedImpl<N> extends ConnectionPoolSettingsFluentImpl<TrafficPolicyFluent.ConnectionPoolNested<N>> implements TrafficPolicyFluent.ConnectionPoolNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConnectionPoolSettingsBuilder builder;
    
            ConnectionPoolNestedImpl(ConnectionPoolSettings item){
                    this.builder = new ConnectionPoolSettingsBuilder(this, item);
            }
            ConnectionPoolNestedImpl(){
                    this.builder = new ConnectionPoolSettingsBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool(){
            return and();
    }

}
    public class LoadBalancerNestedImpl<N> extends LoadBalancerSettingsFluentImpl<TrafficPolicyFluent.LoadBalancerNested<N>> implements TrafficPolicyFluent.LoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LoadBalancerSettingsBuilder builder;
    
            LoadBalancerNestedImpl(LoadBalancerSettings item){
                    this.builder = new LoadBalancerSettingsBuilder(this, item);
            }
            LoadBalancerNestedImpl(){
                    this.builder = new LoadBalancerSettingsBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer(){
            return and();
    }

}
    public class OutlierDetectionNestedImpl<N> extends OutlierDetectionFluentImpl<TrafficPolicyFluent.OutlierDetectionNested<N>> implements TrafficPolicyFluent.OutlierDetectionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OutlierDetectionBuilder builder;
    
            OutlierDetectionNestedImpl(OutlierDetection item){
                    this.builder = new OutlierDetectionBuilder(this, item);
            }
            OutlierDetectionNestedImpl(){
                    this.builder = new OutlierDetectionBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection(){
            return and();
    }

}
    public class PortLevelSettingsNestedImpl<N> extends PortTrafficPolicyFluentImpl<TrafficPolicyFluent.PortLevelSettingsNested<N>> implements TrafficPolicyFluent.PortLevelSettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PortTrafficPolicyBuilder builder;
        private final int index;
    
            PortLevelSettingsNestedImpl(int index,PortTrafficPolicy item){
                    this.index = index;
                    this.builder = new PortTrafficPolicyBuilder(this, item);
            }
            PortLevelSettingsNestedImpl(){
                    this.index = -1;
                    this.builder = new PortTrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.setToPortLevelSettings(index, builder.build());
    }
    public N endPortLevelSetting(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends TLSSettingsFluentImpl<TrafficPolicyFluent.TlsNested<N>> implements TrafficPolicyFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TLSSettingsBuilder builder;
    
            TlsNestedImpl(TLSSettings item){
                    this.builder = new TLSSettingsBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.builder = new TLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withTls(builder.build());
    }
    public N endTls(){
            return and();
    }

}


}
