package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ActionBuilder extends ActionFluentImpl<ActionBuilder> implements VisitableBuilder<Action,ActionBuilder>{

    ActionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ActionBuilder(){
            this(true);
    }
    public ActionBuilder(Boolean validationEnabled){
            this(new Action(), validationEnabled);
    }
    public ActionBuilder(ActionFluent<?> fluent){
            this(fluent, true);
    }
    public ActionBuilder(ActionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Action(), validationEnabled);
    }
    public ActionBuilder(ActionFluent<?> fluent,Action instance){
            this(fluent, instance, true);
    }
    public ActionBuilder(ActionFluent<?> fluent,Action instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHandler(instance.getHandler()); 
            fluent.withInstances(instance.getInstances()); 
            this.validationEnabled = validationEnabled; 
    }
    public ActionBuilder(Action instance){
            this(instance,true);
    }
    public ActionBuilder(Action instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHandler(instance.getHandler()); 
            this.withInstances(instance.getInstances()); 
            this.validationEnabled = validationEnabled; 
    }
    public ActionBuilder(Validator validator){
            this(new Action(), true);
    }
    public ActionBuilder(ActionFluent<?> fluent,Action instance,Validator validator){
            this.fluent = fluent; 
            fluent.withHandler(instance.getHandler()); 
            fluent.withInstances(instance.getInstances()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ActionBuilder(Action instance,Validator validator){
            this.fluent = this; 
            this.withHandler(instance.getHandler()); 
            this.withInstances(instance.getInstances()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Action build(){
            Action buildable = new Action(fluent.getHandler(),fluent.getInstances());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ActionBuilder that = (ActionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
