package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface AccessRuleFluent<A extends AccessRuleFluent<A>> extends Fluent<A>{


    public A addToConstraints(int index,Constraint item);
    public A setToConstraints(int index,Constraint item);
    public A addToConstraints(Constraint... items);
    public A addAllToConstraints(Collection<Constraint> items);
    public A removeFromConstraints(Constraint... items);
    public A removeAllFromConstraints(Collection<Constraint> items);
    
/**
 * This method has been deprecated, please use method buildConstraints instead.
 * @return The buildable object.
 */
@Deprecated public List<Constraint> getConstraints();
    public List<Constraint> buildConstraints();
    public Constraint buildConstraint(int index);
    public Constraint buildFirstConstraint();
    public Constraint buildLastConstraint();
    public Constraint buildMatchingConstraint(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate);
    public A withConstraints(List<Constraint> constraints);
    public A withConstraints(Constraint... constraints);
    public Boolean hasConstraints();
    public AccessRuleFluent.ConstraintsNested<A> addNewConstraint();
    public AccessRuleFluent.ConstraintsNested<A> addNewConstraintLike(Constraint item);
    public AccessRuleFluent.ConstraintsNested<A> setNewConstraintLike(int index,Constraint item);
    public AccessRuleFluent.ConstraintsNested<A> editConstraint(int index);
    public AccessRuleFluent.ConstraintsNested<A> editFirstConstraint();
    public AccessRuleFluent.ConstraintsNested<A> editLastConstraint();
    public AccessRuleFluent.ConstraintsNested<A> editMatchingConstraint(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate);
    public A addToMethods(int index,String item);
    public A setToMethods(int index,String item);
    public A addToMethods(String... items);
    public A addAllToMethods(Collection<String> items);
    public A removeFromMethods(String... items);
    public A removeAllFromMethods(Collection<String> items);
    public List<String> getMethods();
    public String getMethod(int index);
    public String getFirstMethod();
    public String getLastMethod();
    public String getMatchingMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withMethods(List<String> methods);
    public A withMethods(String... methods);
    public Boolean hasMethods();
    public A addToPaths(int index,String item);
    public A setToPaths(int index,String item);
    public A addToPaths(String... items);
    public A addAllToPaths(Collection<String> items);
    public A removeFromPaths(String... items);
    public A removeAllFromPaths(Collection<String> items);
    public List<String> getPaths();
    public String getPath(int index);
    public String getFirstPath();
    public String getLastPath();
    public String getMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withPaths(List<String> paths);
    public A withPaths(String... paths);
    public Boolean hasPaths();
    public A addToServices(int index,String item);
    public A setToServices(int index,String item);
    public A addToServices(String... items);
    public A addAllToServices(Collection<String> items);
    public A removeFromServices(String... items);
    public A removeAllFromServices(Collection<String> items);
    public List<String> getServices();
    public String getService(int index);
    public String getFirstService();
    public String getLastService();
    public String getMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withServices(List<String> services);
    public A withServices(String... services);
    public Boolean hasServices();

    public interface ConstraintsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConstraintFluent<AccessRuleFluent.ConstraintsNested<N>>{

        
    public N and();    public N endConstraint();
}


}
