package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class AccessRuleFluentImpl<A extends AccessRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AccessRuleFluent<A>{

    private List<ConstraintBuilder> constraints;
    private List<String> methods;
    private List<String> paths;
    private List<String> services;

    public AccessRuleFluentImpl(){
    }
    public AccessRuleFluentImpl(AccessRule instance){
            this.withConstraints(instance.getConstraints()); 
            this.withMethods(instance.getMethods()); 
            this.withPaths(instance.getPaths()); 
            this.withServices(instance.getServices()); 
    }

    public A addToConstraints(int index,Constraint item){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.constraints.add(index >= 0 ? index : constraints.size(), builder); return (A)this;
    }

    public A setToConstraints(int index,Constraint item){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            ConstraintBuilder builder = new ConstraintBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= constraints.size()) { constraints.add(builder); } else { constraints.set(index, builder);}
             return (A)this;
    }

    public A addToConstraints(Constraint... items){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.add(builder);this.constraints.add(builder);} return (A)this;
    }

    public A addAllToConstraints(Collection<Constraint> items){
            if (this.constraints == null) {this.constraints = new ArrayList<ConstraintBuilder>();}
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.add(builder);this.constraints.add(builder);} return (A)this;
    }

    public A removeFromConstraints(Constraint... items){
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.remove(builder);if (this.constraints != null) {this.constraints.remove(builder);}} return (A)this;
    }

    public A removeAllFromConstraints(Collection<Constraint> items){
            for (Constraint item : items) {ConstraintBuilder builder = new ConstraintBuilder(item);_visitables.remove(builder);if (this.constraints != null) {this.constraints.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConstraints instead.
 * @return The buildable object.
 */
@Deprecated public List<Constraint> getConstraints(){
            return build(constraints);
    }

    public List<Constraint> buildConstraints(){
            return build(constraints);
    }

    public Constraint buildConstraint(int index){
            return this.constraints.get(index).build();
    }

    public Constraint buildFirstConstraint(){
            return this.constraints.get(0).build();
    }

    public Constraint buildLastConstraint(){
            return this.constraints.get(constraints.size() - 1).build();
    }

    public Constraint buildMatchingConstraint(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate){
            for (ConstraintBuilder item: constraints) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withConstraints(List<Constraint> constraints){
            if (this.constraints != null) { _visitables.removeAll(this.constraints);}
            if (constraints != null) {this.constraints = new ArrayList<ConstraintBuilder>(); for (Constraint item : constraints){this.addToConstraints(item);}} else { this.constraints = null;} return (A) this;
    }

    public A withConstraints(Constraint... constraints){
            if (this.constraints != null) {this.constraints.clear();}
            if (constraints != null) {for (Constraint item :constraints){ this.addToConstraints(item);}} return (A) this;
    }

    public Boolean hasConstraints(){
            return constraints != null && !constraints.isEmpty();
    }

    public AccessRuleFluent.ConstraintsNested<A> addNewConstraint(){
            return new ConstraintsNestedImpl();
    }

    public AccessRuleFluent.ConstraintsNested<A> addNewConstraintLike(Constraint item){
            return new ConstraintsNestedImpl(-1, item);
    }

    public AccessRuleFluent.ConstraintsNested<A> setNewConstraintLike(int index,Constraint item){
            return new ConstraintsNestedImpl(index, item);
    }

    public AccessRuleFluent.ConstraintsNested<A> editConstraint(int index){
            if (constraints.size() <= index) throw new RuntimeException("Can't edit constraints. Index exceeds size.");
            return setNewConstraintLike(index, buildConstraint(index));
    }

    public AccessRuleFluent.ConstraintsNested<A> editFirstConstraint(){
            if (constraints.size() == 0) throw new RuntimeException("Can't edit first constraints. The list is empty.");
            return setNewConstraintLike(0, buildConstraint(0));
    }

    public AccessRuleFluent.ConstraintsNested<A> editLastConstraint(){
            int index = constraints.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last constraints. The list is empty.");
            return setNewConstraintLike(index, buildConstraint(index));
    }

    public AccessRuleFluent.ConstraintsNested<A> editMatchingConstraint(io.fabric8.kubernetes.api.builder.Predicate<ConstraintBuilder> predicate){
            int index = -1;
            for (int i=0;i<constraints.size();i++) { 
            if (predicate.apply(constraints.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching constraints. No match found.");
            return setNewConstraintLike(index, buildConstraint(index));
    }

    public A addToMethods(int index,String item){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            this.methods.add(index, item);
            return (A)this;
    }

    public A setToMethods(int index,String item){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            this.methods.set(index, item); return (A)this;
    }

    public A addToMethods(String... items){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A addAllToMethods(Collection<String> items){
            if (this.methods == null) {this.methods = new ArrayList<String>();}
            for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A removeFromMethods(String... items){
            for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public A removeAllFromMethods(Collection<String> items){
            for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public List<String> getMethods(){
            return this.methods;
    }

    public String getMethod(int index){
            return this.methods.get(index);
    }

    public String getFirstMethod(){
            return this.methods.get(0);
    }

    public String getLastMethod(){
            return this.methods.get(methods.size() - 1);
    }

    public String getMatchingMethod(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: methods) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withMethods(List<String> methods){
            if (this.methods != null) { _visitables.removeAll(this.methods);}
            if (methods != null) {this.methods = new ArrayList<String>(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
    }

    public A withMethods(String... methods){
            if (this.methods != null) {this.methods.clear();}
            if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
    }

    public Boolean hasMethods(){
            return methods != null && !methods.isEmpty();
    }

    public A addToPaths(int index,String item){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            this.paths.add(index, item);
            return (A)this;
    }

    public A setToPaths(int index,String item){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            this.paths.set(index, item); return (A)this;
    }

    public A addToPaths(String... items){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            for (String item : items) {this.paths.add(item);} return (A)this;
    }

    public A addAllToPaths(Collection<String> items){
            if (this.paths == null) {this.paths = new ArrayList<String>();}
            for (String item : items) {this.paths.add(item);} return (A)this;
    }

    public A removeFromPaths(String... items){
            for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public A removeAllFromPaths(Collection<String> items){
            for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
    }

    public List<String> getPaths(){
            return this.paths;
    }

    public String getPath(int index){
            return this.paths.get(index);
    }

    public String getFirstPath(){
            return this.paths.get(0);
    }

    public String getLastPath(){
            return this.paths.get(paths.size() - 1);
    }

    public String getMatchingPath(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: paths) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withPaths(List<String> paths){
            if (this.paths != null) { _visitables.removeAll(this.paths);}
            if (paths != null) {this.paths = new ArrayList<String>(); for (String item : paths){this.addToPaths(item);}} else { this.paths = null;} return (A) this;
    }

    public A withPaths(String... paths){
            if (this.paths != null) {this.paths.clear();}
            if (paths != null) {for (String item :paths){ this.addToPaths(item);}} return (A) this;
    }

    public Boolean hasPaths(){
            return paths != null && !paths.isEmpty();
    }

    public A addToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.add(index, item);
            return (A)this;
    }

    public A setToServices(int index,String item){
            if (this.services == null) {this.services = new ArrayList<String>();}
            this.services.set(index, item); return (A)this;
    }

    public A addToServices(String... items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A addAllToServices(Collection<String> items){
            if (this.services == null) {this.services = new ArrayList<String>();}
            for (String item : items) {this.services.add(item);} return (A)this;
    }

    public A removeFromServices(String... items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public A removeAllFromServices(Collection<String> items){
            for (String item : items) {if (this.services!= null){ this.services.remove(item);}} return (A)this;
    }

    public List<String> getServices(){
            return this.services;
    }

    public String getService(int index){
            return this.services.get(index);
    }

    public String getFirstService(){
            return this.services.get(0);
    }

    public String getLastService(){
            return this.services.get(services.size() - 1);
    }

    public String getMatchingService(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: services) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withServices(List<String> services){
            if (this.services != null) { _visitables.removeAll(this.services);}
            if (services != null) {this.services = new ArrayList<String>(); for (String item : services){this.addToServices(item);}} else { this.services = null;} return (A) this;
    }

    public A withServices(String... services){
            if (this.services != null) {this.services.clear();}
            if (services != null) {for (String item :services){ this.addToServices(item);}} return (A) this;
    }

    public Boolean hasServices(){
            return services != null && !services.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AccessRuleFluentImpl that = (AccessRuleFluentImpl) o;
            if (constraints != null ? !constraints.equals(that.constraints) :that.constraints != null) return false;
            if (methods != null ? !methods.equals(that.methods) :that.methods != null) return false;
            if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
            if (services != null ? !services.equals(that.services) :that.services != null) return false;
            return true;
    }


    public class ConstraintsNestedImpl<N> extends ConstraintFluentImpl<AccessRuleFluent.ConstraintsNested<N>> implements AccessRuleFluent.ConstraintsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConstraintBuilder builder;
        private final int index;
    
            ConstraintsNestedImpl(int index,Constraint item){
                    this.index = index;
                    this.builder = new ConstraintBuilder(this, item);
            }
            ConstraintsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConstraintBuilder(this);
            }
    
    public N and(){
            return (N) AccessRuleFluentImpl.this.setToConstraints(index, builder.build());
    }
    public N endConstraint(){
            return and();
    }

}


}
