package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface RbacConfigFluent<A extends RbacConfigFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public RbacConfigFluent.MetadataNested<A> withNewMetadata();
    public RbacConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public RbacConfigFluent.MetadataNested<A> editMetadata();
    public RbacConfigFluent.MetadataNested<A> editOrNewMetadata();
    public RbacConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public RbacConfigSpec getSpec();
    public RbacConfigSpec buildSpec();
    public A withSpec(RbacConfigSpec spec);
    public Boolean hasSpec();
    public RbacConfigFluent.SpecNested<A> withNewSpec();
    public RbacConfigFluent.SpecNested<A> withNewSpecLike(RbacConfigSpec item);
    public RbacConfigFluent.SpecNested<A> editSpec();
    public RbacConfigFluent.SpecNested<A> editOrNewSpec();
    public RbacConfigFluent.SpecNested<A> editOrNewSpecLike(RbacConfigSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<RbacConfigFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,RbacConfigSpecFluent<RbacConfigFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
