package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RbacConfigListBuilder extends RbacConfigListFluentImpl<RbacConfigListBuilder> implements VisitableBuilder<RbacConfigList,RbacConfigListBuilder>{

    RbacConfigListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RbacConfigListBuilder(){
            this(true);
    }
    public RbacConfigListBuilder(Boolean validationEnabled){
            this(new RbacConfigList(), validationEnabled);
    }
    public RbacConfigListBuilder(RbacConfigListFluent<?> fluent){
            this(fluent, true);
    }
    public RbacConfigListBuilder(RbacConfigListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RbacConfigList(), validationEnabled);
    }
    public RbacConfigListBuilder(RbacConfigListFluent<?> fluent,RbacConfigList instance){
            this(fluent, instance, true);
    }
    public RbacConfigListBuilder(RbacConfigListFluent<?> fluent,RbacConfigList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacConfigListBuilder(RbacConfigList instance){
            this(instance,true);
    }
    public RbacConfigListBuilder(RbacConfigList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public RbacConfigListBuilder(Validator validator){
            this(new RbacConfigList(), true);
    }
    public RbacConfigListBuilder(RbacConfigListFluent<?> fluent,RbacConfigList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RbacConfigListBuilder(RbacConfigList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RbacConfigList build(){
            RbacConfigList buildable = new RbacConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RbacConfigListBuilder that = (RbacConfigListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
