package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServiceRoleSpecBuilder extends ServiceRoleSpecFluentImpl<ServiceRoleSpecBuilder> implements VisitableBuilder<ServiceRoleSpec,ServiceRoleSpecBuilder>{

    ServiceRoleSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceRoleSpecBuilder(){
            this(true);
    }
    public ServiceRoleSpecBuilder(Boolean validationEnabled){
            this(new ServiceRoleSpec(), validationEnabled);
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceRoleSpec(), validationEnabled);
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpecFluent<?> fluent,ServiceRoleSpec instance){
            this(fluent, instance, true);
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpecFluent<?> fluent,ServiceRoleSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpec instance){
            this(instance,true);
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceRoleSpecBuilder(Validator validator){
            this(new ServiceRoleSpec(), true);
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpecFluent<?> fluent,ServiceRoleSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withRules(instance.getRules()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServiceRoleSpecBuilder(ServiceRoleSpec instance,Validator validator){
            this.fluent = this; 
            this.withRules(instance.getRules()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ServiceRoleSpec build(){
            ServiceRoleSpec buildable = new ServiceRoleSpec(fluent.getRules());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceRoleSpecBuilder that = (ServiceRoleSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
