package me.snowdrop.istio.api.rbac.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class SubjectFluentImpl<A extends SubjectFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectFluent<A>{

    private String group;
    private Map<String,String> properties;
    private String user;

    public SubjectFluentImpl(){
    }
    public SubjectFluentImpl(Subject instance){
            this.withGroup(instance.getGroup()); 
            this.withProperties(instance.getProperties()); 
            this.withUser(instance.getUser()); 
    }

    public String getGroup(){
            return this.group;
    }

    public A withGroup(String group){
            this.group=group; return (A) this;
    }

    public Boolean hasGroup(){
            return this.group != null;
    }

    public A addToProperties(String key,String value){
            if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
    }

    public A addToProperties(Map<String,String> map){
            if(this.properties == null && map != null) { this.properties = new LinkedHashMap<String,String>(); }
            if(map != null) { this.properties.putAll(map);} return (A)this;
    }

    public A removeFromProperties(String key){
            if(this.properties == null) { return (A) this; }
            if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
    }

    public A removeFromProperties(Map<String,String> map){
            if(this.properties == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
    }

    public Map<String,String> getProperties(){
            return this.properties;
    }

    public A withProperties(Map<String,String> properties){
            if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap<String,String>(properties);} return (A) this;
    }

    public Boolean hasProperties(){
            return this.properties != null;
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubjectFluentImpl that = (SubjectFluentImpl) o;
            if (group != null ? !group.equals(that.group) :that.group != null) return false;
            if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }




}
