package me.snowdrop.istio.mixer.adapter.bypass;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BypassBuilder extends BypassFluentImpl<BypassBuilder> implements VisitableBuilder<Bypass,BypassBuilder>{

    BypassFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BypassBuilder(){
            this(true);
    }
    public BypassBuilder(Boolean validationEnabled){
            this(new Bypass(), validationEnabled);
    }
    public BypassBuilder(BypassFluent<?> fluent){
            this(fluent, true);
    }
    public BypassBuilder(BypassFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Bypass(), validationEnabled);
    }
    public BypassBuilder(BypassFluent<?> fluent,Bypass instance){
            this(fluent, instance, true);
    }
    public BypassBuilder(BypassFluent<?> fluent,Bypass instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public BypassBuilder(Bypass instance){
            this(instance,true);
    }
    public BypassBuilder(Bypass instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public BypassBuilder(Validator validator){
            this(new Bypass(), true);
    }
    public BypassBuilder(BypassFluent<?> fluent,Bypass instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BypassBuilder(Bypass instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Bypass build(){
            Bypass buildable = new Bypass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BypassBuilder that = (BypassBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
