package me.snowdrop.istio.mixer.adapter.bypass;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BypassListBuilder extends BypassListFluentImpl<BypassListBuilder> implements VisitableBuilder<BypassList,BypassListBuilder>{

    BypassListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BypassListBuilder(){
            this(true);
    }
    public BypassListBuilder(Boolean validationEnabled){
            this(new BypassList(), validationEnabled);
    }
    public BypassListBuilder(BypassListFluent<?> fluent){
            this(fluent, true);
    }
    public BypassListBuilder(BypassListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BypassList(), validationEnabled);
    }
    public BypassListBuilder(BypassListFluent<?> fluent,BypassList instance){
            this(fluent, instance, true);
    }
    public BypassListBuilder(BypassListFluent<?> fluent,BypassList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public BypassListBuilder(BypassList instance){
            this(instance,true);
    }
    public BypassListBuilder(BypassList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public BypassListBuilder(Validator validator){
            this(new BypassList(), true);
    }
    public BypassListBuilder(BypassListFluent<?> fluent,BypassList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BypassListBuilder(BypassList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public BypassList build(){
            BypassList buildable = new BypassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BypassListBuilder that = (BypassListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
