package me.snowdrop.istio.mixer.adapter.circonus;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface CirconusListFluent<A extends CirconusListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Circonus item);
    public A setToItems(int index,Circonus item);
    public A addToItems(Circonus... items);
    public A addAllToItems(Collection<Circonus> items);
    public A removeFromItems(Circonus... items);
    public A removeAllFromItems(Collection<Circonus> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Circonus> getItems();
    public List<Circonus> buildItems();
    public Circonus buildItem(int index);
    public Circonus buildFirstItem();
    public Circonus buildLastItem();
    public Circonus buildMatchingItem(Predicate<CirconusBuilder> predicate);
    public A withItems(List<Circonus> items);
    public A withItems(Circonus... items);
    public Boolean hasItems();
    public CirconusListFluent.ItemsNested<A> addNewItem();
    public CirconusListFluent.ItemsNested<A> addNewItemLike(Circonus item);
    public CirconusListFluent.ItemsNested<A> setNewItemLike(int index,Circonus item);
    public CirconusListFluent.ItemsNested<A> editItem(int index);
    public CirconusListFluent.ItemsNested<A> editFirstItem();
    public CirconusListFluent.ItemsNested<A> editLastItem();
    public CirconusListFluent.ItemsNested<A> editMatchingItem(Predicate<CirconusBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,CirconusFluent<CirconusListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
