
package me.snowdrop.istio.mixer.adapter.denier;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.Status;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "status",
    "validDuration",
    "validUseCount"
})
@IstioKind(name = "denier", plural = "deniers")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class DenierSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("status")
    @JsonPropertyDescription("")
    @Valid
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    @JsonPropertyDescription("")
    private Long validDuration;
    /**
     * 
     * 
     */
    @JsonProperty("validUseCount")
    @JsonPropertyDescription("")
    private Integer validUseCount;
    private final static long serialVersionUID = -2947290673332777L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DenierSpec() {
    }

    /**
     * 
     * @param validDuration
     * @param validUseCount
     * @param status
     */
    public DenierSpec(Status status, Long validDuration, Integer validUseCount) {
        super();
        this.status = status;
        this.validDuration = validDuration;
        this.validUseCount = validUseCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     */
    @JsonProperty("status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public Long getValidDuration() {
        return validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validDuration")
    public void setValidDuration(Long validDuration) {
        this.validDuration = validDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validUseCount")
    public Integer getValidUseCount() {
        return validUseCount;
    }

    /**
     * 
     * 
     */
    @JsonProperty("validUseCount")
    public void setValidUseCount(Integer validUseCount) {
        this.validUseCount = validUseCount;
    }

}
