
package me.snowdrop.istio.mixer.adapter.dogstatsd;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "name",
    "tags",
    "type"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     * 
     */
    @JsonProperty("tags")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, String> tags;
    @JsonProperty("type")
    private Type type;
    private final static long serialVersionUID = 6946548065804723232L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricInfo() {
    }

    /**
     * 
     * @param name
     * @param type
     * @param tags
     */
    public MetricInfo(java.lang.String name, Map<String, String> tags, Type type) {
        super();
        this.name = name;
        this.tags = tags;
        this.type = type;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tags")
    public Map<String, String> getTags() {
        return tags;
    }

    /**
     * 
     * 
     */
    @JsonProperty("tags")
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    @JsonProperty("type")
    public void setType(Type type) {
        this.type = type;
    }

}
