
package me.snowdrop.istio.mixer.adapter.fluentd;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "integerDuration"
})
@IstioKind(name = "fluentd", plural = "fluentds")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class FluentdSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private String address;
    /**
     * 
     * 
     */
    @JsonProperty("integerDuration")
    @JsonPropertyDescription("")
    private Boolean integerDuration;
    private final static long serialVersionUID = -3913313184772640020L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FluentdSpec() {
    }

    /**
     * 
     * @param address
     * @param integerDuration
     */
    public FluentdSpec(String address, Boolean integerDuration) {
        super();
        this.address = address;
        this.integerDuration = integerDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public String getAddress() {
        return address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("address")
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 
     * 
     */
    @JsonProperty("integerDuration")
    public Boolean getIntegerDuration() {
        return integerDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("integerDuration")
    public void setIntegerDuration(Boolean integerDuration) {
        this.integerDuration = integerDuration;
    }

}
