package me.snowdrop.istio.mixer.adapter.fluentd;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class FluentdSpecFluentImpl<A extends FluentdSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FluentdSpecFluent<A>{

    private String address;
    private Boolean integerDuration;

    public FluentdSpecFluentImpl(){
    }
    public FluentdSpecFluentImpl(FluentdSpec instance){
            this.withAddress(instance.getAddress()); 
            this.withIntegerDuration(instance.getIntegerDuration()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public Boolean isIntegerDuration(){
            return this.integerDuration;
    }

    public A withIntegerDuration(Boolean integerDuration){
            this.integerDuration=integerDuration; return (A) this;
    }

    public Boolean hasIntegerDuration(){
            return this.integerDuration != null;
    }

    public A withNewIntegerDuration(String arg1){
            return (A)withIntegerDuration(new Boolean(arg1));
    }

    public A withNewIntegerDuration(boolean arg1){
            return (A)withIntegerDuration(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FluentdSpecFluentImpl that = (FluentdSpecFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (integerDuration != null ? !integerDuration.equals(that.integerDuration) :that.integerDuration != null) return false;
            return true;
    }




}
