package me.snowdrop.istio.mixer.adapter.kubernetesenv;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class KubernetesenvListBuilder extends KubernetesenvListFluentImpl<KubernetesenvListBuilder> implements VisitableBuilder<KubernetesenvList,KubernetesenvListBuilder>{

    KubernetesenvListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesenvListBuilder(){
            this(true);
    }
    public KubernetesenvListBuilder(Boolean validationEnabled){
            this(new KubernetesenvList(), validationEnabled);
    }
    public KubernetesenvListBuilder(KubernetesenvListFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesenvListBuilder(KubernetesenvListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesenvList(), validationEnabled);
    }
    public KubernetesenvListBuilder(KubernetesenvListFluent<?> fluent,KubernetesenvList instance){
            this(fluent, instance, true);
    }
    public KubernetesenvListBuilder(KubernetesenvListFluent<?> fluent,KubernetesenvList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesenvListBuilder(KubernetesenvList instance){
            this(instance,true);
    }
    public KubernetesenvListBuilder(KubernetesenvList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesenvListBuilder(Validator validator){
            this(new KubernetesenvList(), true);
    }
    public KubernetesenvListBuilder(KubernetesenvListFluent<?> fluent,KubernetesenvList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public KubernetesenvListBuilder(KubernetesenvList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public KubernetesenvList build(){
            KubernetesenvList buildable = new KubernetesenvList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesenvListBuilder that = (KubernetesenvListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
