package me.snowdrop.istio.mixer.adapter.list;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface BaseKubernetesListFluent<A extends BaseKubernetesListFluent<A>> extends Fluent<A>{


    public Boolean isBlacklist();
    public A withBlacklist(Boolean blacklist);
    public Boolean hasBlacklist();
    public A withNewBlacklist(String arg1);
    public A withNewBlacklist(boolean arg1);
    public Long getCachingInterval();
    public A withCachingInterval(Long cachingInterval);
    public Boolean hasCachingInterval();
    public A withNewCachingInterval(String arg1);
    public A withNewCachingInterval(long arg1);
    public Integer getCachingUseCount();
    public A withCachingUseCount(Integer cachingUseCount);
    public Boolean hasCachingUseCount();
    public A withNewCachingUseCount(String arg1);
    public A withNewCachingUseCount(int arg1);
    public ListEntryType getEntryType();
    public A withEntryType(ListEntryType entryType);
    public Boolean hasEntryType();
    public A addToOverrides(int index,String item);
    public A setToOverrides(int index,String item);
    public A addToOverrides(String... items);
    public A addAllToOverrides(Collection<String> items);
    public A removeFromOverrides(String... items);
    public A removeAllFromOverrides(Collection<String> items);
    public List<String> getOverrides();
    public String getOverride(int index);
    public String getFirstOverride();
    public String getLastOverride();
    public String getMatchingOverride(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withOverrides(List<String> overrides);
    public A withOverrides(String... overrides);
    public Boolean hasOverrides();
    public String getProviderUrl();
    public A withProviderUrl(String providerUrl);
    public Boolean hasProviderUrl();
    public Long getRefreshInterval();
    public A withRefreshInterval(Long refreshInterval);
    public Boolean hasRefreshInterval();
    public A withNewRefreshInterval(String arg1);
    public A withNewRefreshInterval(long arg1);
    public Long getTtl();
    public A withTtl(Long ttl);
    public Boolean hasTtl();
    public A withNewTtl(String arg1);
    public A withNewTtl(long arg1);



}
