package me.snowdrop.istio.mixer.adapter.opa;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class OpaListBuilder extends OpaListFluentImpl<OpaListBuilder> implements VisitableBuilder<OpaList,OpaListBuilder>{

    OpaListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public OpaListBuilder(){
            this(true);
    }
    public OpaListBuilder(Boolean validationEnabled){
            this(new OpaList(), validationEnabled);
    }
    public OpaListBuilder(OpaListFluent<?> fluent){
            this(fluent, true);
    }
    public OpaListBuilder(OpaListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OpaList(), validationEnabled);
    }
    public OpaListBuilder(OpaListFluent<?> fluent,OpaList instance){
            this(fluent, instance, true);
    }
    public OpaListBuilder(OpaListFluent<?> fluent,OpaList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpaListBuilder(OpaList instance){
            this(instance,true);
    }
    public OpaListBuilder(OpaList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public OpaListBuilder(Validator validator){
            this(new OpaList(), true);
    }
    public OpaListBuilder(OpaListFluent<?> fluent,OpaList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public OpaListBuilder(OpaList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public OpaList build(){
            OpaList buildable = new OpaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OpaListBuilder that = (OpaListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
