package me.snowdrop.istio.mixer.adapter.opa;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface OpaListFluent<A extends OpaListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Opa item);
    public A setToItems(int index,Opa item);
    public A addToItems(Opa... items);
    public A addAllToItems(Collection<Opa> items);
    public A removeFromItems(Opa... items);
    public A removeAllFromItems(Collection<Opa> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Opa> getItems();
    public List<Opa> buildItems();
    public Opa buildItem(int index);
    public Opa buildFirstItem();
    public Opa buildLastItem();
    public Opa buildMatchingItem(Predicate<OpaBuilder> predicate);
    public A withItems(List<Opa> items);
    public A withItems(Opa... items);
    public Boolean hasItems();
    public OpaListFluent.ItemsNested<A> addNewItem();
    public OpaListFluent.ItemsNested<A> addNewItemLike(Opa item);
    public OpaListFluent.ItemsNested<A> setNewItemLike(int index,Opa item);
    public OpaListFluent.ItemsNested<A> editItem(int index);
    public OpaListFluent.ItemsNested<A> editFirstItem();
    public OpaListFluent.ItemsNested<A> editLastItem();
    public OpaListFluent.ItemsNested<A> editMatchingItem(Predicate<OpaBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,OpaFluent<OpaListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
