
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "buckets",
    "description",
    "instanceName",
    "labelNames",
    "name",
    "namespace"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class MetricInfo implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("buckets")
    @JsonPropertyDescription("")
    @Valid
    private BucketsDefinition buckets;
    /**
     * 
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("")
    private String description;
    /**
     * 
     * 
     */
    @JsonProperty("instanceName")
    @JsonPropertyDescription("")
    private String instanceName;
    @JsonProperty("kind")
    private Kind kind;
    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    @JsonPropertyDescription("")
    @Valid
    private List<String> labelNames = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     * 
     */
    @JsonProperty("namespace")
    @JsonPropertyDescription("")
    private String namespace;
    private final static long serialVersionUID = -7295719334328723994L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricInfo() {
    }

    /**
     * 
     * @param labelNames
     * @param instanceName
     * @param kind
     * @param buckets
     * @param name
     * @param namespace
     * @param description
     */
    public MetricInfo(BucketsDefinition buckets, String description, String instanceName, Kind kind, List<String> labelNames, String name, String namespace) {
        super();
        this.buckets = buckets;
        this.description = description;
        this.instanceName = instanceName;
        this.kind = kind;
        this.labelNames = labelNames;
        this.name = name;
        this.namespace = namespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("buckets")
    public BucketsDefinition getBuckets() {
        return buckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("buckets")
    public void setBuckets(BucketsDefinition buckets) {
        this.buckets = buckets;
    }

    /**
     * 
     * 
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * 
     * 
     */
    @JsonProperty("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instanceName")
    public String getInstanceName() {
        return instanceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("instanceName")
    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    @JsonProperty("kind")
    public Kind getKind() {
        return kind;
    }

    @JsonProperty("kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    public List<String> getLabelNames() {
        return labelNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("labelNames")
    public void setLabelNames(List<String> labelNames) {
        this.labelNames = labelNames;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespace")
    public String getNamespace() {
        return namespace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("namespace")
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

}
