package me.snowdrop.istio.mixer.adapter.prometheus;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class MetricsExpirationPolicyBuilder extends MetricsExpirationPolicyFluentImpl<MetricsExpirationPolicyBuilder> implements VisitableBuilder<MetricsExpirationPolicy,MetricsExpirationPolicyBuilder>{

    MetricsExpirationPolicyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public MetricsExpirationPolicyBuilder(){
            this(true);
    }
    public MetricsExpirationPolicyBuilder(Boolean validationEnabled){
            this(new MetricsExpirationPolicy(), validationEnabled);
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new MetricsExpirationPolicy(), validationEnabled);
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicyFluent<?> fluent,MetricsExpirationPolicy instance){
            this(fluent, instance, true);
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicyFluent<?> fluent,MetricsExpirationPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExpiryCheckIntervalDuration(instance.getExpiryCheckIntervalDuration()); 
            fluent.withMetricsExpiryDuration(instance.getMetricsExpiryDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicy instance){
            this(instance,true);
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExpiryCheckIntervalDuration(instance.getExpiryCheckIntervalDuration()); 
            this.withMetricsExpiryDuration(instance.getMetricsExpiryDuration()); 
            this.validationEnabled = validationEnabled; 
    }
    public MetricsExpirationPolicyBuilder(Validator validator){
            this(new MetricsExpirationPolicy(), true);
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicyFluent<?> fluent,MetricsExpirationPolicy instance,Validator validator){
            this.fluent = fluent; 
            fluent.withExpiryCheckIntervalDuration(instance.getExpiryCheckIntervalDuration()); 
            fluent.withMetricsExpiryDuration(instance.getMetricsExpiryDuration()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public MetricsExpirationPolicyBuilder(MetricsExpirationPolicy instance,Validator validator){
            this.fluent = this; 
            this.withExpiryCheckIntervalDuration(instance.getExpiryCheckIntervalDuration()); 
            this.withMetricsExpiryDuration(instance.getMetricsExpiryDuration()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public MetricsExpirationPolicy build(){
            MetricsExpirationPolicy buildable = new MetricsExpirationPolicy(fluent.getExpiryCheckIntervalDuration(),fluent.getMetricsExpiryDuration());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            MetricsExpirationPolicyBuilder that = (MetricsExpirationPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
