
package me.snowdrop.istio.mixer.adapter.prometheus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "metrics",
    "metricsExpirationPolicy"
})
@IstioKind(name = "prometheus", plural = "prometheuses")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class PrometheusSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    @JsonPropertyDescription("")
    @Valid
    private List<MetricInfo> metrics = new ArrayList<MetricInfo>();
    /**
     * 
     * 
     */
    @JsonProperty("metricsExpirationPolicy")
    @JsonPropertyDescription("")
    @Valid
    private MetricsExpirationPolicy metricsExpirationPolicy;
    private final static long serialVersionUID = 5708816579760453012L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PrometheusSpec() {
    }

    /**
     * 
     * @param metrics
     * @param metricsExpirationPolicy
     */
    public PrometheusSpec(List<MetricInfo> metrics, MetricsExpirationPolicy metricsExpirationPolicy) {
        super();
        this.metrics = metrics;
        this.metricsExpirationPolicy = metricsExpirationPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public List<MetricInfo> getMetrics() {
        return metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metrics")
    public void setMetrics(List<MetricInfo> metrics) {
        this.metrics = metrics;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricsExpirationPolicy")
    public MetricsExpirationPolicy getMetricsExpirationPolicy() {
        return metricsExpirationPolicy;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricsExpirationPolicy")
    public void setMetricsExpirationPolicy(MetricsExpirationPolicy metricsExpirationPolicy) {
        this.metricsExpirationPolicy = metricsExpirationPolicy;
    }

}
