
package me.snowdrop.istio.mixer.adapter.rbac;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "cacheDuration",
    "configStoreUrl"
})
@IstioKind(name = "rbac", plural = "rbacs")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class RbacSpec implements Serializable, IstioSpec
{

    /**
     * 
     * 
     */
    @JsonProperty("cacheDuration")
    @JsonPropertyDescription("")
    private Long cacheDuration;
    /**
     * 
     * 
     */
    @JsonProperty("configStoreUrl")
    @JsonPropertyDescription("")
    private String configStoreUrl;
    private final static long serialVersionUID = 7392497388717029930L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RbacSpec() {
    }

    /**
     * 
     * @param configStoreUrl
     * @param cacheDuration
     */
    public RbacSpec(Long cacheDuration, String configStoreUrl) {
        super();
        this.cacheDuration = cacheDuration;
        this.configStoreUrl = configStoreUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cacheDuration")
    public Long getCacheDuration() {
        return cacheDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("cacheDuration")
    public void setCacheDuration(Long cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    /**
     * 
     * 
     */
    @JsonProperty("configStoreUrl")
    public String getConfigStoreUrl() {
        return configStoreUrl;
    }

    /**
     * 
     * 
     */
    @JsonProperty("configStoreUrl")
    public void setConfigStoreUrl(String configStoreUrl) {
        this.configStoreUrl = configStoreUrl;
    }

}
