
package me.snowdrop.istio.mixer.adapter.servicecontrol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "googleServiceName",
    "meshServiceName",
    "quotas"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
public class GcpServiceSetting implements Serializable
{

    /**
     * 
     * 
     */
    @JsonProperty("googleServiceName")
    @JsonPropertyDescription("")
    private String googleServiceName;
    /**
     * 
     * 
     */
    @JsonProperty("meshServiceName")
    @JsonPropertyDescription("")
    private String meshServiceName;
    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    @JsonPropertyDescription("")
    @Valid
    private List<Quota> quotas = new ArrayList<Quota>();
    private final static long serialVersionUID = 3893646681054710438L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public GcpServiceSetting() {
    }

    /**
     * 
     * @param quotas
     * @param meshServiceName
     * @param googleServiceName
     */
    public GcpServiceSetting(String googleServiceName, String meshServiceName, List<Quota> quotas) {
        super();
        this.googleServiceName = googleServiceName;
        this.meshServiceName = meshServiceName;
        this.quotas = quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("googleServiceName")
    public String getGoogleServiceName() {
        return googleServiceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("googleServiceName")
    public void setGoogleServiceName(String googleServiceName) {
        this.googleServiceName = googleServiceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("meshServiceName")
    public String getMeshServiceName() {
        return meshServiceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("meshServiceName")
    public void setMeshServiceName(String meshServiceName) {
        this.meshServiceName = meshServiceName;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public List<Quota> getQuotas() {
        return quotas;
    }

    /**
     * 
     * 
     */
    @JsonProperty("quotas")
    public void setQuotas(List<Quota> quotas) {
        this.quotas = quotas;
    }

}
