package me.snowdrop.istio.mixer.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class GcpServiceSettingBuilder extends GcpServiceSettingFluentImpl<GcpServiceSettingBuilder> implements VisitableBuilder<GcpServiceSetting,GcpServiceSettingBuilder>{

    GcpServiceSettingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GcpServiceSettingBuilder(){
            this(true);
    }
    public GcpServiceSettingBuilder(Boolean validationEnabled){
            this(new GcpServiceSetting(), validationEnabled);
    }
    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent){
            this(fluent, true);
    }
    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GcpServiceSetting(), validationEnabled);
    }
    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent,GcpServiceSetting instance){
            this(fluent, instance, true);
    }
    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent,GcpServiceSetting instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGoogleServiceName(instance.getGoogleServiceName()); 
            fluent.withMeshServiceName(instance.getMeshServiceName()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public GcpServiceSettingBuilder(GcpServiceSetting instance){
            this(instance,true);
    }
    public GcpServiceSettingBuilder(GcpServiceSetting instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGoogleServiceName(instance.getGoogleServiceName()); 
            this.withMeshServiceName(instance.getMeshServiceName()); 
            this.withQuotas(instance.getQuotas()); 
            this.validationEnabled = validationEnabled; 
    }
    public GcpServiceSettingBuilder(Validator validator){
            this(new GcpServiceSetting(), true);
    }
    public GcpServiceSettingBuilder(GcpServiceSettingFluent<?> fluent,GcpServiceSetting instance,Validator validator){
            this.fluent = fluent; 
            fluent.withGoogleServiceName(instance.getGoogleServiceName()); 
            fluent.withMeshServiceName(instance.getMeshServiceName()); 
            fluent.withQuotas(instance.getQuotas()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public GcpServiceSettingBuilder(GcpServiceSetting instance,Validator validator){
            this.fluent = this; 
            this.withGoogleServiceName(instance.getGoogleServiceName()); 
            this.withMeshServiceName(instance.getMeshServiceName()); 
            this.withQuotas(instance.getQuotas()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public GcpServiceSetting build(){
            GcpServiceSetting buildable = new GcpServiceSetting(fluent.getGoogleServiceName(),fluent.getMeshServiceName(),fluent.getQuotas());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GcpServiceSettingBuilder that = (GcpServiceSettingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
