package me.snowdrop.istio.mixer.adapter.servicecontrol;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class GcpServiceSettingFluentImpl<A extends GcpServiceSettingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GcpServiceSettingFluent<A>{

    private String googleServiceName;
    private String meshServiceName;
    private List<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder> quotas;

    public GcpServiceSettingFluentImpl(){
    }
    public GcpServiceSettingFluentImpl(GcpServiceSetting instance){
            this.withGoogleServiceName(instance.getGoogleServiceName()); 
            this.withMeshServiceName(instance.getMeshServiceName()); 
            this.withQuotas(instance.getQuotas()); 
    }

    public String getGoogleServiceName(){
            return this.googleServiceName;
    }

    public A withGoogleServiceName(String googleServiceName){
            this.googleServiceName=googleServiceName; return (A) this;
    }

    public Boolean hasGoogleServiceName(){
            return this.googleServiceName != null;
    }

    public String getMeshServiceName(){
            return this.meshServiceName;
    }

    public A withMeshServiceName(String meshServiceName){
            this.meshServiceName=meshServiceName; return (A) this;
    }

    public Boolean hasMeshServiceName(){
            return this.meshServiceName != null;
    }

    public A addToQuotas(int index,me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder>();}
            me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.quotas.add(index >= 0 ? index : quotas.size(), builder); return (A)this;
    }

    public A setToQuotas(int index,me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder>();}
            me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= quotas.size()) { quotas.add(builder); } else { quotas.set(index, builder);}
             return (A)this;
    }

    public A addToQuotas(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota... items){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item : items) {me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(item);_visitables.add(builder);this.quotas.add(builder);} return (A)this;
    }

    public A addAllToQuotas(Collection<me.snowdrop.istio.mixer.adapter.servicecontrol.Quota> items){
            if (this.quotas == null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder>();}
            for (me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item : items) {me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(item);_visitables.add(builder);this.quotas.add(builder);} return (A)this;
    }

    public A removeFromQuotas(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota... items){
            for (me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item : items) {me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(item);_visitables.remove(builder);if (this.quotas != null) {this.quotas.remove(builder);}} return (A)this;
    }

    public A removeAllFromQuotas(Collection<me.snowdrop.istio.mixer.adapter.servicecontrol.Quota> items){
            for (me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item : items) {me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(item);_visitables.remove(builder);if (this.quotas != null) {this.quotas.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildQuotas instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.mixer.adapter.servicecontrol.Quota> getQuotas(){
            return build(quotas);
    }

    public List<me.snowdrop.istio.mixer.adapter.servicecontrol.Quota> buildQuotas(){
            return build(quotas);
    }

    public me.snowdrop.istio.mixer.adapter.servicecontrol.Quota buildQuota(int index){
            return this.quotas.get(index).build();
    }

    public me.snowdrop.istio.mixer.adapter.servicecontrol.Quota buildFirstQuota(){
            return this.quotas.get(0).build();
    }

    public me.snowdrop.istio.mixer.adapter.servicecontrol.Quota buildLastQuota(){
            return this.quotas.get(quotas.size() - 1).build();
    }

    public me.snowdrop.istio.mixer.adapter.servicecontrol.Quota buildMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder> predicate){
            for (me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder item: quotas) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withQuotas(List<me.snowdrop.istio.mixer.adapter.servicecontrol.Quota> quotas){
            if (this.quotas != null) { _visitables.removeAll(this.quotas);}
            if (quotas != null) {this.quotas = new ArrayList<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder>(); for (me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item : quotas){this.addToQuotas(item);}} else { this.quotas = null;} return (A) this;
    }

    public A withQuotas(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota... quotas){
            if (this.quotas != null) {this.quotas.clear();}
            if (quotas != null) {for (me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item :quotas){ this.addToQuotas(item);}} return (A) this;
    }

    public Boolean hasQuotas(){
            return quotas != null && !quotas.isEmpty();
    }

    public GcpServiceSettingFluent.QuotasNested<A> addNewQuota(){
            return new QuotasNestedImpl();
    }

    public GcpServiceSettingFluent.QuotasNested<A> addNewQuotaLike(me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item){
            return new QuotasNestedImpl(-1, item);
    }

    public GcpServiceSettingFluent.QuotasNested<A> setNewQuotaLike(int index,me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item){
            return new QuotasNestedImpl(index, item);
    }

    public GcpServiceSettingFluent.QuotasNested<A> editQuota(int index){
            if (quotas.size() <= index) throw new RuntimeException("Can't edit quotas. Index exceeds size.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public GcpServiceSettingFluent.QuotasNested<A> editFirstQuota(){
            if (quotas.size() == 0) throw new RuntimeException("Can't edit first quotas. The list is empty.");
            return setNewQuotaLike(0, buildQuota(0));
    }

    public GcpServiceSettingFluent.QuotasNested<A> editLastQuota(){
            int index = quotas.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last quotas. The list is empty.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public GcpServiceSettingFluent.QuotasNested<A> editMatchingQuota(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder> predicate){
            int index = -1;
            for (int i=0;i<quotas.size();i++) { 
            if (predicate.apply(quotas.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching quotas. No match found.");
            return setNewQuotaLike(index, buildQuota(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GcpServiceSettingFluentImpl that = (GcpServiceSettingFluentImpl) o;
            if (googleServiceName != null ? !googleServiceName.equals(that.googleServiceName) :that.googleServiceName != null) return false;
            if (meshServiceName != null ? !meshServiceName.equals(that.meshServiceName) :that.meshServiceName != null) return false;
            if (quotas != null ? !quotas.equals(that.quotas) :that.quotas != null) return false;
            return true;
    }


    public class QuotasNestedImpl<N> extends me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaFluentImpl<GcpServiceSettingFluent.QuotasNested<N>> implements GcpServiceSettingFluent.QuotasNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder builder;
        private final int index;
    
            QuotasNestedImpl(int index,me.snowdrop.istio.mixer.adapter.servicecontrol.Quota item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(this, item);
            }
            QuotasNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.mixer.adapter.servicecontrol.QuotaBuilder(this);
            }
    
    public N and(){
            return (N) GcpServiceSettingFluentImpl.this.setToQuotas(index, builder.build());
    }
    public N endQuota(){
            return and();
    }

}


}
