package me.snowdrop.istio.mixer.adapter.servicecontrol;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface ServicecontrolListFluent<A extends ServicecontrolListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Servicecontrol item);
    public A setToItems(int index,Servicecontrol item);
    public A addToItems(Servicecontrol... items);
    public A addAllToItems(Collection<Servicecontrol> items);
    public A removeFromItems(Servicecontrol... items);
    public A removeAllFromItems(Collection<Servicecontrol> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Servicecontrol> getItems();
    public List<Servicecontrol> buildItems();
    public Servicecontrol buildItem(int index);
    public Servicecontrol buildFirstItem();
    public Servicecontrol buildLastItem();
    public Servicecontrol buildMatchingItem(Predicate<ServicecontrolBuilder> predicate);
    public A withItems(List<Servicecontrol> items);
    public A withItems(Servicecontrol... items);
    public Boolean hasItems();
    public ServicecontrolListFluent.ItemsNested<A> addNewItem();
    public ServicecontrolListFluent.ItemsNested<A> addNewItemLike(Servicecontrol item);
    public ServicecontrolListFluent.ItemsNested<A> setNewItemLike(int index,Servicecontrol item);
    public ServicecontrolListFluent.ItemsNested<A> editItem(int index);
    public ServicecontrolListFluent.ItemsNested<A> editFirstItem();
    public ServicecontrolListFluent.ItemsNested<A> editLastItem();
    public ServicecontrolListFluent.ItemsNested<A> editMatchingItem(Predicate<ServicecontrolBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ServicecontrolFluent<ServicecontrolListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
