package me.snowdrop.istio.mixer.adapter.servicecontrol;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServicecontrolListFluentImpl<A extends ServicecontrolListFluent<A>> extends BaseFluent<A> implements ServicecontrolListFluent<A>{

    private String apiVersion;
    private List<ServicecontrolBuilder> items;
    private String kind;
    private ListMeta metadata;

    public ServicecontrolListFluentImpl(){
    }
    public ServicecontrolListFluentImpl(ServicecontrolList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,Servicecontrol item){
            if (this.items == null) {this.items = new ArrayList<ServicecontrolBuilder>();}
            ServicecontrolBuilder builder = new ServicecontrolBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,Servicecontrol item){
            if (this.items == null) {this.items = new ArrayList<ServicecontrolBuilder>();}
            ServicecontrolBuilder builder = new ServicecontrolBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(Servicecontrol... items){
            if (this.items == null) {this.items = new ArrayList<ServicecontrolBuilder>();}
            for (Servicecontrol item : items) {ServicecontrolBuilder builder = new ServicecontrolBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<Servicecontrol> items){
            if (this.items == null) {this.items = new ArrayList<ServicecontrolBuilder>();}
            for (Servicecontrol item : items) {ServicecontrolBuilder builder = new ServicecontrolBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Servicecontrol... items){
            for (Servicecontrol item : items) {ServicecontrolBuilder builder = new ServicecontrolBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<Servicecontrol> items){
            for (Servicecontrol item : items) {ServicecontrolBuilder builder = new ServicecontrolBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Servicecontrol> getItems(){
            return build(items);
    }

    public List<Servicecontrol> buildItems(){
            return build(items);
    }

    public Servicecontrol buildItem(int index){
            return this.items.get(index).build();
    }

    public Servicecontrol buildFirstItem(){
            return this.items.get(0).build();
    }

    public Servicecontrol buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public Servicecontrol buildMatchingItem(Predicate<ServicecontrolBuilder> predicate){
            for (ServicecontrolBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<Servicecontrol> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<ServicecontrolBuilder>(); for (Servicecontrol item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(Servicecontrol... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (Servicecontrol item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public ServicecontrolListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public ServicecontrolListFluent.ItemsNested<A> addNewItemLike(Servicecontrol item){
            return new ItemsNestedImpl(-1, item);
    }

    public ServicecontrolListFluent.ItemsNested<A> setNewItemLike(int index,Servicecontrol item){
            return new ItemsNestedImpl(index, item);
    }

    public ServicecontrolListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public ServicecontrolListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public ServicecontrolListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public ServicecontrolListFluent.ItemsNested<A> editMatchingItem(Predicate<ServicecontrolBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServicecontrolListFluentImpl that = (ServicecontrolListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends ServicecontrolFluentImpl<ServicecontrolListFluent.ItemsNested<N>> implements ServicecontrolListFluent.ItemsNested<N>,Nested<N>{

            private final ServicecontrolBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,Servicecontrol item){
                    this.index = index;
                    this.builder = new ServicecontrolBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ServicecontrolBuilder(this);
            }
    
    public N and(){
            return (N) ServicecontrolListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
