package me.snowdrop.istio.mixer.adapter.servicecontrol;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ServicecontrolSpecBuilder extends ServicecontrolSpecFluentImpl<ServicecontrolSpecBuilder> implements VisitableBuilder<ServicecontrolSpec,ServicecontrolSpecBuilder>{

    ServicecontrolSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServicecontrolSpecBuilder(){
            this(true);
    }
    public ServicecontrolSpecBuilder(Boolean validationEnabled){
            this(new ServicecontrolSpec(), validationEnabled);
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServicecontrolSpec(), validationEnabled);
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpecFluent<?> fluent,ServicecontrolSpec instance){
            this(fluent, instance, true);
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpecFluent<?> fluent,ServicecontrolSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCredentialPath(instance.getCredentialPath()); 
            fluent.withRuntimeConfig(instance.getRuntimeConfig()); 
            fluent.withServiceConfigs(instance.getServiceConfigs()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpec instance){
            this(instance,true);
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCredentialPath(instance.getCredentialPath()); 
            this.withRuntimeConfig(instance.getRuntimeConfig()); 
            this.withServiceConfigs(instance.getServiceConfigs()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServicecontrolSpecBuilder(Validator validator){
            this(new ServicecontrolSpec(), true);
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpecFluent<?> fluent,ServicecontrolSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withCredentialPath(instance.getCredentialPath()); 
            fluent.withRuntimeConfig(instance.getRuntimeConfig()); 
            fluent.withServiceConfigs(instance.getServiceConfigs()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ServicecontrolSpecBuilder(ServicecontrolSpec instance,Validator validator){
            this.fluent = this; 
            this.withCredentialPath(instance.getCredentialPath()); 
            this.withRuntimeConfig(instance.getRuntimeConfig()); 
            this.withServiceConfigs(instance.getServiceConfigs()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ServicecontrolSpec build(){
            ServicecontrolSpec buildable = new ServicecontrolSpec(fluent.getCredentialPath(),fluent.getRuntimeConfig(),fluent.getServiceConfigs());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServicecontrolSpecBuilder that = (ServicecontrolSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
