package me.snowdrop.istio.mixer.adapter.signalfx;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface SignalfxListFluent<A extends SignalfxListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Signalfx item);
    public A setToItems(int index,Signalfx item);
    public A addToItems(Signalfx... items);
    public A addAllToItems(Collection<Signalfx> items);
    public A removeFromItems(Signalfx... items);
    public A removeAllFromItems(Collection<Signalfx> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Signalfx> getItems();
    public List<Signalfx> buildItems();
    public Signalfx buildItem(int index);
    public Signalfx buildFirstItem();
    public Signalfx buildLastItem();
    public Signalfx buildMatchingItem(Predicate<SignalfxBuilder> predicate);
    public A withItems(List<Signalfx> items);
    public A withItems(Signalfx... items);
    public Boolean hasItems();
    public SignalfxListFluent.ItemsNested<A> addNewItem();
    public SignalfxListFluent.ItemsNested<A> addNewItemLike(Signalfx item);
    public SignalfxListFluent.ItemsNested<A> setNewItemLike(int index,Signalfx item);
    public SignalfxListFluent.ItemsNested<A> editItem(int index);
    public SignalfxListFluent.ItemsNested<A> editFirstItem();
    public SignalfxListFluent.ItemsNested<A> editLastItem();
    public SignalfxListFluent.ItemsNested<A> editMatchingItem(Predicate<SignalfxBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,SignalfxFluent<SignalfxListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
