package me.snowdrop.istio.mixer.adapter.signalfx;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class SignalfxSpecBuilder extends SignalfxSpecFluentImpl<SignalfxSpecBuilder> implements VisitableBuilder<SignalfxSpec,SignalfxSpecBuilder>{

    SignalfxSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SignalfxSpecBuilder(){
            this(true);
    }
    public SignalfxSpecBuilder(Boolean validationEnabled){
            this(new SignalfxSpec(), validationEnabled);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SignalfxSpec(), validationEnabled);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent,SignalfxSpec instance){
            this(fluent, instance, true);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent,SignalfxSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAccessToken(instance.getAccessToken()); 
            fluent.withDatapointInterval(instance.getDatapointInterval()); 
            fluent.withIngestUrl(instance.getIngestUrl()); 
            fluent.withMetrics(instance.getMetrics()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignalfxSpecBuilder(SignalfxSpec instance){
            this(instance,true);
    }
    public SignalfxSpecBuilder(SignalfxSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAccessToken(instance.getAccessToken()); 
            this.withDatapointInterval(instance.getDatapointInterval()); 
            this.withIngestUrl(instance.getIngestUrl()); 
            this.withMetrics(instance.getMetrics()); 
            this.validationEnabled = validationEnabled; 
    }
    public SignalfxSpecBuilder(Validator validator){
            this(new SignalfxSpec(), true);
    }
    public SignalfxSpecBuilder(SignalfxSpecFluent<?> fluent,SignalfxSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAccessToken(instance.getAccessToken()); 
            fluent.withDatapointInterval(instance.getDatapointInterval()); 
            fluent.withIngestUrl(instance.getIngestUrl()); 
            fluent.withMetrics(instance.getMetrics()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public SignalfxSpecBuilder(SignalfxSpec instance,Validator validator){
            this.fluent = this; 
            this.withAccessToken(instance.getAccessToken()); 
            this.withDatapointInterval(instance.getDatapointInterval()); 
            this.withIngestUrl(instance.getIngestUrl()); 
            this.withMetrics(instance.getMetrics()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public SignalfxSpec build(){
            SignalfxSpec buildable = new SignalfxSpec(fluent.getAccessToken(),fluent.getDatapointInterval(),fluent.getIngestUrl(),fluent.getMetrics());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SignalfxSpecBuilder that = (SignalfxSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
