package me.snowdrop.istio.mixer.adapter.signalfx;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface SignalfxSpecFluent<A extends SignalfxSpecFluent<A>> extends Fluent<A>{


    public String getAccessToken();
    public A withAccessToken(String accessToken);
    public Boolean hasAccessToken();
    public Long getDatapointInterval();
    public A withDatapointInterval(Long datapointInterval);
    public Boolean hasDatapointInterval();
    public A withNewDatapointInterval(String arg1);
    public A withNewDatapointInterval(long arg1);
    public String getIngestUrl();
    public A withIngestUrl(String ingestUrl);
    public Boolean hasIngestUrl();
    public A addToMetrics(int index,MetricConfig item);
    public A setToMetrics(int index,MetricConfig item);
    public A addToMetrics(MetricConfig... items);
    public A addAllToMetrics(Collection<MetricConfig> items);
    public A removeFromMetrics(MetricConfig... items);
    public A removeAllFromMetrics(Collection<MetricConfig> items);
    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<MetricConfig> getMetrics();
    public List<MetricConfig> buildMetrics();
    public MetricConfig buildMetric(int index);
    public MetricConfig buildFirstMetric();
    public MetricConfig buildLastMetric();
    public MetricConfig buildMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricConfigBuilder> predicate);
    public A withMetrics(List<MetricConfig> metrics);
    public A withMetrics(MetricConfig... metrics);
    public Boolean hasMetrics();
    public SignalfxSpecFluent.MetricsNested<A> addNewMetric();
    public SignalfxSpecFluent.MetricsNested<A> addNewMetricLike(MetricConfig item);
    public SignalfxSpecFluent.MetricsNested<A> setNewMetricLike(int index,MetricConfig item);
    public SignalfxSpecFluent.MetricsNested<A> editMetric(int index);
    public SignalfxSpecFluent.MetricsNested<A> editFirstMetric();
    public SignalfxSpecFluent.MetricsNested<A> editLastMetric();
    public SignalfxSpecFluent.MetricsNested<A> editMatchingMetric(io.fabric8.kubernetes.api.builder.Predicate<MetricConfigBuilder> predicate);

    public interface MetricsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MetricConfigFluent<SignalfxSpecFluent.MetricsNested<N>>{

        
    public N and();    public N endMetric();
}


}
