package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface SolarwindsFluent<A extends SolarwindsFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public SolarwindsFluent.MetadataNested<A> withNewMetadata();
    public SolarwindsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public SolarwindsFluent.MetadataNested<A> editMetadata();
    public SolarwindsFluent.MetadataNested<A> editOrNewMetadata();
    public SolarwindsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public SolarwindsSpec getSpec();
    public SolarwindsSpec buildSpec();
    public A withSpec(SolarwindsSpec spec);
    public Boolean hasSpec();
    public SolarwindsFluent.SpecNested<A> withNewSpec();
    public SolarwindsFluent.SpecNested<A> withNewSpecLike(SolarwindsSpec item);
    public SolarwindsFluent.SpecNested<A> editSpec();
    public SolarwindsFluent.SpecNested<A> editOrNewSpec();
    public SolarwindsFluent.SpecNested<A> editOrNewSpecLike(SolarwindsSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<SolarwindsFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,SolarwindsSpecFluent<SolarwindsFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
