package me.snowdrop.istio.mixer.adapter.solarwinds;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface SolarwindsListFluent<A extends SolarwindsListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Solarwinds item);
    public A setToItems(int index,Solarwinds item);
    public A addToItems(Solarwinds... items);
    public A addAllToItems(Collection<Solarwinds> items);
    public A removeFromItems(Solarwinds... items);
    public A removeAllFromItems(Collection<Solarwinds> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Solarwinds> getItems();
    public List<Solarwinds> buildItems();
    public Solarwinds buildItem(int index);
    public Solarwinds buildFirstItem();
    public Solarwinds buildLastItem();
    public Solarwinds buildMatchingItem(Predicate<SolarwindsBuilder> predicate);
    public A withItems(List<Solarwinds> items);
    public A withItems(Solarwinds... items);
    public Boolean hasItems();
    public SolarwindsListFluent.ItemsNested<A> addNewItem();
    public SolarwindsListFluent.ItemsNested<A> addNewItemLike(Solarwinds item);
    public SolarwindsListFluent.ItemsNested<A> setNewItemLike(int index,Solarwinds item);
    public SolarwindsListFluent.ItemsNested<A> editItem(int index);
    public SolarwindsListFluent.ItemsNested<A> editFirstItem();
    public SolarwindsListFluent.ItemsNested<A> editLastItem();
    public SolarwindsListFluent.ItemsNested<A> editMatchingItem(Predicate<SolarwindsBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,SolarwindsFluent<SolarwindsListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
