package me.snowdrop.istio.mixer.adapter.solarwinds;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Boolean;
import java.util.Map;

public interface SolarwindsSpecFluent<A extends SolarwindsSpecFluent<A>> extends Fluent<A>{


    public String getAppopticsAccessToken();
    public A withAppopticsAccessToken(String appopticsAccessToken);
    public Boolean hasAppopticsAccessToken();
    public Integer getAppopticsBatchSize();
    public A withAppopticsBatchSize(Integer appopticsBatchSize);
    public Boolean hasAppopticsBatchSize();
    public A withNewAppopticsBatchSize(String arg1);
    public A withNewAppopticsBatchSize(int arg1);
    public A addToLogs(String key,LogInfo value);
    public A addToLogs(Map<String,LogInfo> map);
    public A removeFromLogs(String key);
    public A removeFromLogs(Map<String,LogInfo> map);
    public Map<String,LogInfo> getLogs();
    public A withLogs(Map<String,LogInfo> logs);
    public Boolean hasLogs();
    public A addToMetrics(String key,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo value);
    public A addToMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> map);
    public A removeFromMetrics(String key);
    public A removeFromMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> map);
    public Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> getMetrics();
    public A withMetrics(Map<String,me.snowdrop.istio.mixer.adapter.solarwinds.MetricInfo> metrics);
    public Boolean hasMetrics();
    public Long getPapertrailLocalRetentionDuration();
    public A withPapertrailLocalRetentionDuration(Long papertrailLocalRetentionDuration);
    public Boolean hasPapertrailLocalRetentionDuration();
    public A withNewPapertrailLocalRetentionDuration(String arg1);
    public A withNewPapertrailLocalRetentionDuration(long arg1);
    public String getPapertrailUrl();
    public A withPapertrailUrl(String papertrailUrl);
    public Boolean hasPapertrailUrl();



}
