
package me.snowdrop.istio.mixer.adapter.stackdriver;

import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "creds",
    "endpoint",
    "logInfo",
    "metricInfo",
    "projectId",
    "pushInterval",
    "trace"
})
@IstioKind(name = "stackdriver", plural = "stackdrivers")
@IstioApiVersion("config.istio.io/v1alpha2")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class StackdriverSpec implements Serializable, IstioSpec
{

    @JsonProperty("creds")
    @JsonUnwrapped
    private me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpec.Creds creds;
    /**
     * 
     * 
     */
    @JsonProperty("endpoint")
    @JsonPropertyDescription("")
    private java.lang.String endpoint;
    /**
     * 
     * 
     */
    @JsonProperty("logInfo")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, LogInfo> logInfo;
    /**
     * 
     * 
     */
    @JsonProperty("metricInfo")
    @JsonPropertyDescription("")
    @Valid
    private Map<String, MetricInfo> metricInfo;
    /**
     * 
     * 
     */
    @JsonProperty("projectId")
    @JsonPropertyDescription("")
    private java.lang.String projectId;
    /**
     * 
     * 
     */
    @JsonProperty("pushInterval")
    @JsonPropertyDescription("")
    private Long pushInterval;
    /**
     * 
     * 
     */
    @JsonProperty("trace")
    @JsonPropertyDescription("")
    @Valid
    private Trace trace;
    private final static long serialVersionUID = 3379575561759834900L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StackdriverSpec() {
    }

    /**
     * 
     * @param endpoint
     * @param trace
     * @param metricInfo
     * @param logInfo
     * @param pushInterval
     * @param creds
     * @param projectId
     */
    public StackdriverSpec(me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpec.Creds creds, java.lang.String endpoint, Map<String, LogInfo> logInfo, Map<String, MetricInfo> metricInfo, java.lang.String projectId, Long pushInterval, Trace trace) {
        super();
        this.creds = creds;
        this.endpoint = endpoint;
        this.logInfo = logInfo;
        this.metricInfo = metricInfo;
        this.projectId = projectId;
        this.pushInterval = pushInterval;
        this.trace = trace;
    }

    @JsonProperty("creds")
    public me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpec.Creds getCreds() {
        return creds;
    }

    @JsonProperty("creds")
    public void setCreds(me.snowdrop.istio.mixer.adapter.stackdriver.StackdriverSpec.Creds creds) {
        this.creds = creds;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endpoint")
    public java.lang.String getEndpoint() {
        return endpoint;
    }

    /**
     * 
     * 
     */
    @JsonProperty("endpoint")
    public void setEndpoint(java.lang.String endpoint) {
        this.endpoint = endpoint;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logInfo")
    public Map<String, LogInfo> getLogInfo() {
        return logInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("logInfo")
    public void setLogInfo(Map<String, LogInfo> logInfo) {
        this.logInfo = logInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricInfo")
    public Map<String, MetricInfo> getMetricInfo() {
        return metricInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("metricInfo")
    public void setMetricInfo(Map<String, MetricInfo> metricInfo) {
        this.metricInfo = metricInfo;
    }

    /**
     * 
     * 
     */
    @JsonProperty("projectId")
    public java.lang.String getProjectId() {
        return projectId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("projectId")
    public void setProjectId(java.lang.String projectId) {
        this.projectId = projectId;
    }

    /**
     * 
     * 
     */
    @JsonProperty("pushInterval")
    public Long getPushInterval() {
        return pushInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("pushInterval")
    public void setPushInterval(Long pushInterval) {
        this.pushInterval = pushInterval;
    }

    /**
     * 
     * 
     */
    @JsonProperty("trace")
    public Trace getTrace() {
        return trace;
    }

    /**
     * 
     * 
     */
    @JsonProperty("trace")
    public void setTrace(Trace trace) {
        this.trace = trace;
    }

    public interface Creds extends Serializable
    {


    }

}
