package me.snowdrop.istio.mixer.adapter.statsd;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Boolean;

public interface StatsdFluent<A extends StatsdFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public StatsdFluent.MetadataNested<A> withNewMetadata();
    public StatsdFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public StatsdFluent.MetadataNested<A> editMetadata();
    public StatsdFluent.MetadataNested<A> editOrNewMetadata();
    public StatsdFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public StatsdSpec getSpec();
    public StatsdSpec buildSpec();
    public A withSpec(StatsdSpec spec);
    public Boolean hasSpec();
    public StatsdFluent.SpecNested<A> withNewSpec();
    public StatsdFluent.SpecNested<A> withNewSpecLike(StatsdSpec item);
    public StatsdFluent.SpecNested<A> editSpec();
    public StatsdFluent.SpecNested<A> editOrNewSpec();
    public StatsdFluent.SpecNested<A> editOrNewSpecLike(StatsdSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<StatsdFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,StatsdSpecFluent<StatsdFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
