package me.snowdrop.istio.mixer.adapter.statsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StatsdSpecBuilder extends StatsdSpecFluentImpl<StatsdSpecBuilder> implements VisitableBuilder<StatsdSpec,StatsdSpecBuilder>{

    StatsdSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StatsdSpecBuilder(){
            this(true);
    }
    public StatsdSpecBuilder(Boolean validationEnabled){
            this(new StatsdSpec(), validationEnabled);
    }
    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent){
            this(fluent, true);
    }
    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StatsdSpec(), validationEnabled);
    }
    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent,StatsdSpec instance){
            this(fluent, instance, true);
    }
    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent,StatsdSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withFlushBytes(instance.getFlushBytes()); 
            fluent.withFlushDuration(instance.getFlushDuration()); 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withPrefix(instance.getPrefix()); 
            fluent.withSamplingRate(instance.getSamplingRate()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatsdSpecBuilder(StatsdSpec instance){
            this(instance,true);
    }
    public StatsdSpecBuilder(StatsdSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withFlushBytes(instance.getFlushBytes()); 
            this.withFlushDuration(instance.getFlushDuration()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPrefix(instance.getPrefix()); 
            this.withSamplingRate(instance.getSamplingRate()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatsdSpecBuilder(Validator validator){
            this(new StatsdSpec(), true);
    }
    public StatsdSpecBuilder(StatsdSpecFluent<?> fluent,StatsdSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withFlushBytes(instance.getFlushBytes()); 
            fluent.withFlushDuration(instance.getFlushDuration()); 
            fluent.withMetrics(instance.getMetrics()); 
            fluent.withPrefix(instance.getPrefix()); 
            fluent.withSamplingRate(instance.getSamplingRate()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StatsdSpecBuilder(StatsdSpec instance,Validator validator){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withFlushBytes(instance.getFlushBytes()); 
            this.withFlushDuration(instance.getFlushDuration()); 
            this.withMetrics(instance.getMetrics()); 
            this.withPrefix(instance.getPrefix()); 
            this.withSamplingRate(instance.getSamplingRate()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public StatsdSpec build(){
            StatsdSpec buildable = new StatsdSpec(fluent.getAddress(),fluent.getFlushBytes(),fluent.getFlushDuration(),fluent.getMetrics(),fluent.getPrefix(),fluent.getSamplingRate());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatsdSpecBuilder that = (StatsdSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
